/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.WeatherUnitEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CapacityUnitToISO20022UnitOfMeasure;
import drr.regulation.common.functions.Contract_Price_Monetary;
import drr.regulation.common.functions.FinancialUnitToISO20022UnitOfMeasure;
import drr.regulation.common.functions.WeatherUnitToISO20022UnitOfMeasure;
import javax.inject.Inject;

@ImplementedBy(value=CDEPriceUnitOfMeasureRuleDefault.class)
public abstract class CDEPriceUnitOfMeasureRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected CapacityUnitToISO20022UnitOfMeasure capacityUnitToISO20022UnitOfMeasure;
    @Inject
    protected Contract_Price_Monetary contract_Price_Monetary;
    @Inject
    protected FinancialUnitToISO20022UnitOfMeasure financialUnitToISO20022UnitOfMeasure;
    @Inject
    protected WeatherUnitToISO20022UnitOfMeasure weatherUnitToISO20022UnitOfMeasure;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class CDEPriceUnitOfMeasureRuleDefault
    extends CDEPriceUnitOfMeasureRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperC thenArg0 = MapperS.of((Object)input).mapSingleToList(item -> MapperC.of(this.contract_Price_Monetary.evaluate((ReportableEvent)item.get())));
            MapperS thenArg1 = MapperS.of((Object)((PriceSchedule)thenArg0.get()));
            output = (String)thenArg1.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.capacityUnitToISO20022UnitOfMeasure.evaluate((CapacityUnitEnum)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.weatherUnitToISO20022UnitOfMeasure.evaluate((WeatherUnitEnum)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.financialUnitToISO20022UnitOfMeasure.evaluate((FinancialUnitEnum)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
                }
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.ofNull();
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

