/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

@ImplementedBy(value=CDESettlementCurrencyRuleDefault.class)
public abstract class CDESettlementCurrencyRule
implements ReportFunction<SettlementTerms, ISOCurrencyCodeEnum> {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;

    public ISOCurrencyCodeEnum evaluate(SettlementTerms input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(SettlementTerms var1);

    public static class CDESettlementCurrencyRuleDefault
    extends CDESettlementCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(SettlementTerms input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, SettlementTerms input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)item.mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getSettlementCurrency", settlementTerms -> settlementTerms.getSettlementCurrency());
                }
                return MapperS.ofNull();
            });
            output = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

