/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.types.RObject;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.rosetta.model.lib.ModelSymbolId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class REnumType
extends RType
implements RObject {
    private final RosettaEnumeration enumeration;
    private ModelSymbolId symbolId = null;
    private REnumType parent = null;
    private final ModelIdProvider modelIdProvider;
    private final RObjectFactory objectFactory;

    public REnumType(RosettaEnumeration enumeration, ModelIdProvider modelIdProvider, RObjectFactory objectFactory) {
        this.enumeration = enumeration;
        this.modelIdProvider = modelIdProvider;
        this.objectFactory = objectFactory;
    }

    public ModelSymbolId getSymbolId() {
        if (this.symbolId == null) {
            this.symbolId = this.modelIdProvider.getSymbolId(this.enumeration);
        }
        return this.symbolId;
    }

    @Override
    public RosettaEnumeration getEObject() {
        return this.enumeration;
    }

    public REnumType getParent() {
        if (this.enumeration.getParent() != null && this.parent == null) {
            this.parent = this.objectFactory.buildREnumType(this.enumeration.getParent());
        }
        return this.parent;
    }

    public List<REnumType> getAllParents() {
        LinkedHashSet<REnumType> reversedResult = new LinkedHashSet<REnumType>();
        this.doGetAllParents(this, reversedResult);
        List result = reversedResult.stream().collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(result);
        return result;
    }

    private void doGetAllParents(REnumType current, LinkedHashSet<REnumType> parents) {
        REnumType p;
        if (parents.add(current) && (p = current.getParent()) != null) {
            this.doGetAllParents(p, parents);
        }
    }

    public List<RosettaEnumValue> getOwnEnumValues() {
        return this.enumeration.getEnumValues();
    }

    public List<RosettaEnumValue> getAllEnumValues() {
        return this.getAllParents().stream().flatMap(p -> p.getOwnEnumValues().stream()).collect(Collectors.toList());
    }

    public int hashCode() {
        return 31 + (this.enumeration == null ? 0 : this.enumeration.hashCode());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        REnumType other = (REnumType)object;
        return Objects.equals(this.enumeration, other.enumeration);
    }
}

