/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeclarativeRosettaValidator
extends AbstractDeclarativeValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDeclarativeRosettaValidator.class);
    @Inject
    private RosettaEcoreUtil ecoreUtil;

    protected List<EPackage> getEPackages() {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.rosetta-model.com/Rosetta"));
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.rosetta-model.com/RosettaSimple"));
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.rosetta-model.com/RosettaExpression"));
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.rosetta-model.com/RosettaTranslate"));
        return result;
    }

    public void register(EValidatorRegistrar registrar) {
    }

    protected void handleExceptionDuringValidation(Throwable targetException) throws RuntimeException {
        super.handleExceptionDuringValidation(targetException);
        LOGGER.error(targetException.getMessage(), targetException);
    }

    protected AbstractDeclarativeValidator.MethodWrapper createMethodWrapper(AbstractDeclarativeValidator instanceToUse, Method method) {
        return new RosettaMethodWrapper(instanceToUse, method);
    }

    protected void errorKeyword(String message, EObject o, Keyword keyword) {
        INode k = this.findDirectKeyword(o, keyword);
        if (k != null) {
            this.getMessageAcceptor().acceptError(message, o, k.getOffset(), k.getLength(), null, new String[0]);
        }
    }

    protected void errorKeyword(String message, EObject o, String keyword) {
        INode k = this.findDirectKeyword(o, keyword);
        if (k != null) {
            this.getMessageAcceptor().acceptError(message, o, k.getOffset(), k.getLength(), null, new String[0]);
        }
    }

    protected INode findDirectKeyword(EObject o, Keyword keyword) {
        return this.findDirectKeyword(o, keyword.getValue());
    }

    protected INode findDirectKeyword(EObject o, String keyword) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)o);
        return this.findDirectKeyword(node, keyword);
    }

    protected INode findDirectKeyword(ICompositeNode node, String keyword) {
        for (INode n : node.getChildren()) {
            INode keywordInFragment;
            EObject ge = n.getGrammarElement();
            if (ge instanceof Keyword && ((Keyword)ge).getValue().equals(keyword)) {
                return n;
            }
            if (!(ge instanceof RuleCall) && !(ge instanceof Action) || !(n instanceof ICompositeNode) || ge.eContainer() instanceof Assignment || (keywordInFragment = this.findDirectKeyword((ICompositeNode)n, keyword)) == null) continue;
            return keywordInFragment;
        }
        return null;
    }

    protected void checkDeprecatedAnnotation(Annotated annotated, EObject owner, EStructuralFeature ref, int index) {
        Attribute parent;
        if (annotated.getAnnotations().stream().anyMatch(ann -> this.ecoreUtil.isResolved(ann.getAnnotation()) && "deprecated".equals(ann.getAnnotation().getName()))) {
            Object msg = annotated instanceof RosettaNamed ? ((RosettaNamed)((Object)annotated)).getName() + " is deprecated" : "Deprecated";
            this.info((String)msg, owner, ref, index);
        } else if (annotated instanceof Attribute && (parent = this.ecoreUtil.getParentAttribute((Attribute)annotated)) != null) {
            this.checkDeprecatedAnnotation(parent, owner, ref, index);
        }
    }

    private static class RosettaMethodWrapper
    extends AbstractDeclarativeValidator.MethodWrapper {
        protected RosettaMethodWrapper(AbstractDeclarativeValidator instance, Method m) {
            super(instance, m);
        }

        public void invoke(AbstractDeclarativeValidator.State state) {
            try {
                super.invoke(state);
            }
            catch (Exception e) {
                String message = "Unexpected validation failure running " + this.getMethod().getName();
                LOGGER.error(message, (Throwable)e);
                state.hasErrors = true;
                state.chain.add(this.createDiagnostic(message, state));
            }
        }

        private Diagnostic createDiagnostic(String message, AbstractDeclarativeValidator.State state) {
            return new FeatureBasedDiagnostic(4, message, state.currentObject, null, -1, state.currentCheckType, null, new String[0]);
        }
    }
}

