/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.validation.datarule;

import cdm.base.datetime.Offset;
import cdm.base.datetime.PeriodEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="OffsetDayType")
@ImplementedBy(value=Default.class)
public interface OffsetDayType
extends Validator<Offset> {
    public static final String NAME = "OffsetDayType";
    public static final String DEFINITION = "if period <> PeriodEnum -> D or periodMultiplier = 0 then dayType is absent";

    public static class NoOp
    implements OffsetDayType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Offset offset) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements OffsetDayType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Offset offset) {
            ComparisonResult result = this.executeDataRule(offset);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)OffsetDayType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Offset", (RosettaPath)path, (String)OffsetDayType.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)OffsetDayType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Offset", (RosettaPath)path, (String)OffsetDayType.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Offset offset) {
            try {
                if (ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)offset).map("getPeriod", _offset -> _offset.getPeriod()), (Mapper)MapperS.of((Object)((Object)PeriodEnum.D)), (CardinalityOperator)CardinalityOperator.Any).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)offset).map("getPeriodMultiplier", _offset -> _offset.getPeriodMultiplier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)offset).map("getDayType", _offset -> _offset.getDayType()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

