/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.RoundingDirectionEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=RoundToSignificantFiguresDefault.class)
public abstract class RoundToSignificantFigures
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;

    public BigDecimal evaluate(BigDecimal value, Integer significantFigures, RoundingDirectionEnum roundingMode) {
        this.conditionValidator.validate(() -> ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)significantFigures), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All), "The number of significant figures should be greater than zero.");
        BigDecimal roundedValue = this.doEvaluate(value, significantFigures, roundingMode);
        return roundedValue;
    }

    protected abstract BigDecimal doEvaluate(BigDecimal var1, Integer var2, RoundingDirectionEnum var3);

    public static class RoundToSignificantFiguresDefault
    extends RoundToSignificantFigures {
        @Override
        protected BigDecimal doEvaluate(BigDecimal value, Integer significantFigures, RoundingDirectionEnum roundingMode) {
            BigDecimal roundedValue = null;
            return this.assignOutput(roundedValue, value, significantFigures, roundingMode);
        }

        protected BigDecimal assignOutput(BigDecimal roundedValue, BigDecimal value, Integer significantFigures, RoundingDirectionEnum roundingMode) {
            return roundedValue;
        }
    }
}

