/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.observable.asset.PriceTypeEnum;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ImplementedBy(value=ExtractTradeCollateralPriceDefault.class)
public abstract class ExtractTradeCollateralPrice
implements RosettaFunction {
    public List<BigDecimal> evaluate(TradableProduct tradableProduct) {
        List<BigDecimal> value = this.doEvaluate(tradableProduct);
        return value;
    }

    protected abstract List<BigDecimal> doEvaluate(TradableProduct var1);

    public static class ExtractTradeCollateralPriceDefault
    extends ExtractTradeCollateralPrice {
        @Override
        protected List<BigDecimal> doEvaluate(TradableProduct tradableProduct) {
            ArrayList<BigDecimal> value = new ArrayList<BigDecimal>();
            return this.assignOutput(value, tradableProduct);
        }

        protected List<BigDecimal> assignOutput(List<BigDecimal> value, TradableProduct tradableProduct) {
            MapperListOfLists thenArg0 = MapperS.of((Object)((TradeLot)MapperS.of((Object)tradableProduct).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapItemToList(item -> item.mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
            MapperC thenArg1 = thenArg0.flattenList();
            MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.ASSET_PRICE)), (CardinalityOperator)CardinalityOperator.All).get());
            value = thenArg2.mapItem(item -> item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue())).getMulti();
            return value;
        }
    }
}

