/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.Transfer;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=TransfersForDateDefault.class)
public abstract class TransfersForDate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends Transfer> evaluate(List<? extends Transfer> transfers, Date date) {
        List transfersForDate;
        List<Transfer.TransferBuilder> transfersForDateBuilder = this.doEvaluate(transfers, date);
        if (transfersForDateBuilder == null) {
            transfersForDate = null;
        } else {
            transfersForDate = transfersForDateBuilder.stream().map(Transfer::build).collect(Collectors.toList());
            this.objectValidator.validate(Transfer.class, transfersForDate);
        }
        return transfersForDate;
    }

    protected abstract List<Transfer.TransferBuilder> doEvaluate(List<? extends Transfer> var1, Date var2);

    public static class TransfersForDateDefault
    extends TransfersForDate {
        @Override
        protected List<Transfer.TransferBuilder> doEvaluate(List<? extends Transfer> transfers, Date date) {
            if (transfers == null) {
                transfers = Collections.emptyList();
            }
            ArrayList<Transfer.TransferBuilder> transfersForDate = new ArrayList<Transfer.TransferBuilder>();
            return this.assignOutput(transfersForDate, transfers, date);
        }

        protected List<Transfer.TransferBuilder> assignOutput(List<Transfer.TransferBuilder> transfersForDate, List<? extends Transfer> transfers, Date date) {
            transfersForDate.addAll(this.toBuilder(MapperC.of(transfers).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getSettlementDate", transfer -> transfer.getSettlementDate()).map("getAdjustedDate", adjustableOrAdjustedOrRelativeDate -> adjustableOrAdjustedOrRelativeDate.getAdjustedDate()).map("Type coercion", fieldWithMetaDate -> fieldWithMetaDate == null ? null : fieldWithMetaDate.getValue()), (Mapper)MapperS.of((Object)date), (CardinalityOperator)CardinalityOperator.All).get()).getMulti()));
            return Optional.ofNullable(transfersForDate).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

