/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Instruction;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="InstructionExclusiveSplitPrimitive")
@ImplementedBy(value=Default.class)
public interface InstructionExclusiveSplitPrimitive
extends Validator<Instruction> {
    public static final String NAME = "InstructionExclusiveSplitPrimitive";
    public static final String DEFINITION = "if primitiveInstruction -> split exists then primitiveInstruction -> split only exists";

    public static class NoOp
    implements InstructionExclusiveSplitPrimitive {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Instruction instruction) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements InstructionExclusiveSplitPrimitive {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Instruction instruction) {
            ComparisonResult result = this.executeDataRule(instruction);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)InstructionExclusiveSplitPrimitive.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionExclusiveSplitPrimitive.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)InstructionExclusiveSplitPrimitive.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionExclusiveSplitPrimitive.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Instruction instruction) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)instruction).map("getPrimitiveInstruction", _instruction -> _instruction.getPrimitiveInstruction()).map("getSplit", primitiveInstruction -> primitiveInstruction.getSplit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.onlyExists((Mapper)MapperS.of((Object)instruction).map("getPrimitiveInstruction", _instruction -> _instruction.getPrimitiveInstruction()), Arrays.asList("contractFormation", "execution", "exercise", "partyChange", "quantityChange", "reset", "split", "termsChange", "transfer", "indexTransition", "stockSplit", "observation", "valuation"), Arrays.asList("split"));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

