/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.State;
import cdm.event.position.PositionStatusEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="StateClosedStateExists")
@ImplementedBy(value=Default.class)
public interface StateClosedStateExists
extends Validator<State> {
    public static final String NAME = "StateClosedStateExists";
    public static final String DEFINITION = "if positionState = PositionStatusEnum -> Closed then closedState exists";

    public static class NoOp
    implements StateClosedStateExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, State state) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements StateClosedStateExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, State state) {
            ComparisonResult result = this.executeDataRule(state);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)StateClosedStateExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"State", (RosettaPath)path, (String)StateClosedStateExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)StateClosedStateExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"State", (RosettaPath)path, (String)StateClosedStateExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(State state) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)state).map("getPositionState", _state -> _state.getPositionState()), (Mapper)MapperS.of((Object)((Object)PositionStatusEnum.CLOSED)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)state).map("getClosedState", _state -> _state.getClosedState()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

