/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.datetime.Period;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.observable.asset.QuotationSideEnum;
import cdm.observable.asset.meta.SwapCurveValuationMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SwapCurveValuation", builder=SwapCurveValuationBuilderImpl.class, version="5.31.0")
@RuneDataType(value="SwapCurveValuation", model="cdm", builder=SwapCurveValuationBuilderImpl.class, version="5.31.0")
public interface SwapCurveValuation
extends RosettaModelObject {
    public static final SwapCurveValuationMeta metaData = new SwapCurveValuationMeta();

    public FloatingRateIndexEnum getFloatingRateIndex();

    public Period getIndexTenor();

    public BigDecimal getSpread();

    public QuotationSideEnum getSide();

    public SwapCurveValuation build();

    public SwapCurveValuationBuilder toBuilder();

    public static SwapCurveValuationBuilder builder() {
        return new SwapCurveValuationBuilderImpl();
    }

    default public RosettaMetaData<? extends SwapCurveValuation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SwapCurveValuation> getType() {
        return SwapCurveValuation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("floatingRateIndex"), FloatingRateIndexEnum.class, (Object)this.getFloatingRateIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexTenor"), processor, Period.class, this.getIndexTenor(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("side"), QuotationSideEnum.class, (Object)this.getSide(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SwapCurveValuationBuilderImpl
    implements SwapCurveValuationBuilder {
        protected FloatingRateIndexEnum floatingRateIndex;
        protected Period.PeriodBuilder indexTenor;
        protected BigDecimal spread;
        protected QuotationSideEnum side;

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public FloatingRateIndexEnum getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public Period.PeriodBuilder getIndexTenor() {
            return this.indexTenor;
        }

        @Override
        public Period.PeriodBuilder getOrCreateIndexTenor() {
            Period.PeriodBuilder result = this.indexTenor != null ? this.indexTenor : (this.indexTenor = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spread", isRequired=true)
        @RuneAttribute(value="spread", isRequired=true)
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public QuotationSideEnum getSide() {
            return this.side;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public SwapCurveValuationBuilder setFloatingRateIndex(FloatingRateIndexEnum _floatingRateIndex) {
            this.floatingRateIndex = _floatingRateIndex == null ? null : _floatingRateIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public SwapCurveValuationBuilder setIndexTenor(Period _indexTenor) {
            this.indexTenor = _indexTenor == null ? null : _indexTenor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spread", isRequired=true)
        @RuneAttribute(value="spread", isRequired=true)
        public SwapCurveValuationBuilder setSpread(BigDecimal _spread) {
            this.spread = _spread == null ? null : _spread;
            return this;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public SwapCurveValuationBuilder setSide(QuotationSideEnum _side) {
            this.side = _side == null ? null : _side;
            return this;
        }

        @Override
        public SwapCurveValuation build() {
            return new SwapCurveValuationImpl(this);
        }

        @Override
        public SwapCurveValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public SwapCurveValuationBuilder prune() {
            if (this.indexTenor != null && !this.indexTenor.prune().hasData()) {
                this.indexTenor = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFloatingRateIndex() != null) {
                return true;
            }
            if (this.getIndexTenor() != null && this.getIndexTenor().hasData()) {
                return true;
            }
            if (this.getSpread() != null) {
                return true;
            }
            return this.getSide() != null;
        }

        public SwapCurveValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SwapCurveValuationBuilder o = (SwapCurveValuationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexTenor(), (RosettaModelObjectBuilder)o.getIndexTenor(), this::setIndexTenor);
            merger.mergeBasic((Object)this.getFloatingRateIndex(), (Object)o.getFloatingRateIndex(), this::setFloatingRateIndex, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpread(), (Object)o.getSpread(), this::setSpread, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSide(), (Object)o.getSide(), this::setSide, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SwapCurveValuation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.floatingRateIndex, (Object)_that.getFloatingRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.indexTenor, _that.getIndexTenor())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            return Objects.equals((Object)this.side, (Object)_that.getSide());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRateIndex != null ? ((Object)((Object)this.floatingRateIndex)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.indexTenor != null ? this.indexTenor.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.side != null ? ((Object)((Object)this.side)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SwapCurveValuationBuilder {floatingRateIndex=" + (Object)((Object)this.floatingRateIndex) + ", indexTenor=" + this.indexTenor + ", spread=" + this.spread + ", side=" + (Object)((Object)this.side) + '}';
        }
    }

    public static interface SwapCurveValuationBuilder
    extends SwapCurveValuation,
    RosettaModelObjectBuilder {
        public Period.PeriodBuilder getOrCreateIndexTenor();

        @Override
        public Period.PeriodBuilder getIndexTenor();

        public SwapCurveValuationBuilder setFloatingRateIndex(FloatingRateIndexEnum var1);

        public SwapCurveValuationBuilder setIndexTenor(Period var1);

        public SwapCurveValuationBuilder setSpread(BigDecimal var1);

        public SwapCurveValuationBuilder setSide(QuotationSideEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("floatingRateIndex"), FloatingRateIndexEnum.class, (Object)this.getFloatingRateIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexTenor"), processor, Period.PeriodBuilder.class, this.getIndexTenor(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("side"), QuotationSideEnum.class, (Object)this.getSide(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SwapCurveValuationBuilder prune();
    }

    public static class SwapCurveValuationImpl
    implements SwapCurveValuation {
        private final FloatingRateIndexEnum floatingRateIndex;
        private final Period indexTenor;
        private final BigDecimal spread;
        private final QuotationSideEnum side;

        protected SwapCurveValuationImpl(SwapCurveValuationBuilder builder) {
            this.floatingRateIndex = builder.getFloatingRateIndex();
            this.indexTenor = Optional.ofNullable(builder.getIndexTenor()).map(f -> f.build()).orElse(null);
            this.spread = builder.getSpread();
            this.side = builder.getSide();
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public FloatingRateIndexEnum getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public Period getIndexTenor() {
            return this.indexTenor;
        }

        @Override
        @RosettaAttribute(value="spread", isRequired=true)
        @RuneAttribute(value="spread", isRequired=true)
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public QuotationSideEnum getSide() {
            return this.side;
        }

        @Override
        public SwapCurveValuation build() {
            return this;
        }

        @Override
        public SwapCurveValuationBuilder toBuilder() {
            SwapCurveValuationBuilder builder = SwapCurveValuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SwapCurveValuationBuilder builder) {
            Optional.ofNullable(this.getFloatingRateIndex()).ifPresent(builder::setFloatingRateIndex);
            Optional.ofNullable(this.getIndexTenor()).ifPresent(builder::setIndexTenor);
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
            Optional.ofNullable(this.getSide()).ifPresent(builder::setSide);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SwapCurveValuation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.floatingRateIndex, (Object)_that.getFloatingRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.indexTenor, _that.getIndexTenor())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            return Objects.equals((Object)this.side, (Object)_that.getSide());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRateIndex != null ? ((Object)((Object)this.floatingRateIndex)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.indexTenor != null ? this.indexTenor.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.side != null ? ((Object)((Object)this.side)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SwapCurveValuation {floatingRateIndex=" + (Object)((Object)this.floatingRateIndex) + ", indexTenor=" + this.indexTenor + ", spread=" + this.spread + ", side=" + (Object)((Object)this.side) + '}';
        }
    }
}

