/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.math.AveragingWeightingMethodEnum;
import cdm.base.math.Rounding;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.Price;
import cdm.observable.asset.calculatedrate.FallbackRateParameters;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRate;
import cdm.product.asset.NegativeInterestRateTreatmentEnum;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.SpreadSchedule;
import cdm.product.asset.meta.FloatingRateSpecificationMeta;
import cdm.product.common.schedule.RateSchedule;
import cdm.product.template.StrikeSchedule;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FloatingRateSpecification", builder=FloatingRateSpecificationBuilderImpl.class, version="5.31.0")
@RuneDataType(value="FloatingRateSpecification", model="cdm", builder=FloatingRateSpecificationBuilderImpl.class, version="5.31.0")
public interface FloatingRateSpecification
extends FloatingRate {
    public static final FloatingRateSpecificationMeta metaData = new FloatingRateSpecificationMeta();

    public Price getInitialRate();

    public Rounding getFinalRateRounding();

    public AveragingWeightingMethodEnum getAveragingMethod();

    public NegativeInterestRateTreatmentEnum getNegativeInterestRateTreatment();

    @Override
    public FloatingRateSpecification build();

    @Override
    public FloatingRateSpecificationBuilder toBuilder();

    public static FloatingRateSpecificationBuilder builder() {
        return new FloatingRateSpecificationBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingRateSpecification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingRateSpecification> getType() {
        return FloatingRateSpecification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("rateOption"), processor, ReferenceWithMetaFloatingRateOption.class, this.getRateOption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadSchedule"), processor, SpreadSchedule.class, this.getSpreadSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("capRateSchedule"), processor, StrikeSchedule.class, this.getCapRateSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floorRateSchedule"), processor, StrikeSchedule.class, this.getFloorRateSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateMultiplierSchedule"), processor, RateSchedule.class, this.getFloatingRateMultiplierSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rateTreatment"), RateTreatmentEnum.class, (Object)this.getRateTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationParameters"), processor, FloatingRateCalculationParameters.class, this.getCalculationParameters(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fallbackRate"), processor, FallbackRateParameters.class, this.getFallbackRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initialRate"), processor, Price.class, this.getInitialRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalRateRounding"), processor, Rounding.class, this.getFinalRateRounding(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("averagingMethod"), AveragingWeightingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("negativeInterestRateTreatment"), NegativeInterestRateTreatmentEnum.class, (Object)this.getNegativeInterestRateTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FloatingRateSpecificationBuilderImpl
    extends FloatingRate.FloatingRateBuilderImpl
    implements FloatingRateSpecificationBuilder {
        protected Price.PriceBuilder initialRate;
        protected Rounding.RoundingBuilder finalRateRounding;
        protected AveragingWeightingMethodEnum averagingMethod;
        protected NegativeInterestRateTreatmentEnum negativeInterestRateTreatment;

        @Override
        @RosettaAttribute(value="initialRate")
        @RuneAttribute(value="initialRate")
        public Price.PriceBuilder getInitialRate() {
            return this.initialRate;
        }

        @Override
        public Price.PriceBuilder getOrCreateInitialRate() {
            Price.PriceBuilder result = this.initialRate != null ? this.initialRate : (this.initialRate = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="finalRateRounding")
        @RuneAttribute(value="finalRateRounding")
        public Rounding.RoundingBuilder getFinalRateRounding() {
            return this.finalRateRounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateFinalRateRounding() {
            Rounding.RoundingBuilder result = this.finalRateRounding != null ? this.finalRateRounding : (this.finalRateRounding = Rounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public AveragingWeightingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="negativeInterestRateTreatment")
        @RuneAttribute(value="negativeInterestRateTreatment")
        public NegativeInterestRateTreatmentEnum getNegativeInterestRateTreatment() {
            return this.negativeInterestRateTreatment;
        }

        @Override
        @RosettaAttribute(value="rateOption")
        @RuneAttribute(value="rateOption")
        @RuneScopedAttributeReference
        public FloatingRateSpecificationBuilder setRateOption(ReferenceWithMetaFloatingRateOption _rateOption) {
            this.rateOption = _rateOption == null ? null : _rateOption.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setRateOptionValue(FloatingRateOption _rateOption) {
            this.getOrCreateRateOption().setValue(_rateOption);
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public FloatingRateSpecificationBuilder setSpreadSchedule(SpreadSchedule _spreadSchedule) {
            this.spreadSchedule = _spreadSchedule == null ? null : _spreadSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="capRateSchedule")
        @RuneAttribute(value="capRateSchedule")
        public FloatingRateSpecificationBuilder setCapRateSchedule(StrikeSchedule _capRateSchedule) {
            this.capRateSchedule = _capRateSchedule == null ? null : _capRateSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floorRateSchedule")
        @RuneAttribute(value="floorRateSchedule")
        public FloatingRateSpecificationBuilder setFloorRateSchedule(StrikeSchedule _floorRateSchedule) {
            this.floorRateSchedule = _floorRateSchedule == null ? null : _floorRateSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public FloatingRateSpecificationBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateMultiplierSchedule")
        @RuneAttribute(value="floatingRateMultiplierSchedule")
        public FloatingRateSpecificationBuilder setFloatingRateMultiplierSchedule(RateSchedule _floatingRateMultiplierSchedule) {
            this.floatingRateMultiplierSchedule = _floatingRateMultiplierSchedule == null ? null : _floatingRateMultiplierSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rateTreatment")
        @RuneAttribute(value="rateTreatment")
        public FloatingRateSpecificationBuilder setRateTreatment(RateTreatmentEnum _rateTreatment) {
            this.rateTreatment = _rateTreatment == null ? null : _rateTreatment;
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationParameters")
        @RuneAttribute(value="calculationParameters")
        public FloatingRateSpecificationBuilder setCalculationParameters(FloatingRateCalculationParameters _calculationParameters) {
            this.calculationParameters = _calculationParameters == null ? null : _calculationParameters.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fallbackRate")
        @RuneAttribute(value="fallbackRate")
        public FloatingRateSpecificationBuilder setFallbackRate(FallbackRateParameters _fallbackRate) {
            this.fallbackRate = _fallbackRate == null ? null : _fallbackRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="initialRate")
        @RuneAttribute(value="initialRate")
        public FloatingRateSpecificationBuilder setInitialRate(Price _initialRate) {
            this.initialRate = _initialRate == null ? null : _initialRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="finalRateRounding")
        @RuneAttribute(value="finalRateRounding")
        public FloatingRateSpecificationBuilder setFinalRateRounding(Rounding _finalRateRounding) {
            this.finalRateRounding = _finalRateRounding == null ? null : _finalRateRounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public FloatingRateSpecificationBuilder setAveragingMethod(AveragingWeightingMethodEnum _averagingMethod) {
            this.averagingMethod = _averagingMethod == null ? null : _averagingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="negativeInterestRateTreatment")
        @RuneAttribute(value="negativeInterestRateTreatment")
        public FloatingRateSpecificationBuilder setNegativeInterestRateTreatment(NegativeInterestRateTreatmentEnum _negativeInterestRateTreatment) {
            this.negativeInterestRateTreatment = _negativeInterestRateTreatment == null ? null : _negativeInterestRateTreatment;
            return this;
        }

        @Override
        public FloatingRateSpecification build() {
            return new FloatingRateSpecificationImpl(this);
        }

        @Override
        public FloatingRateSpecificationBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder prune() {
            super.prune();
            if (this.initialRate != null && !this.initialRate.prune().hasData()) {
                this.initialRate = null;
            }
            if (this.finalRateRounding != null && !this.finalRateRounding.prune().hasData()) {
                this.finalRateRounding = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInitialRate() != null && this.getInitialRate().hasData()) {
                return true;
            }
            if (this.getFinalRateRounding() != null && this.getFinalRateRounding().hasData()) {
                return true;
            }
            if (this.getAveragingMethod() != null) {
                return true;
            }
            return this.getNegativeInterestRateTreatment() != null;
        }

        @Override
        public FloatingRateSpecificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FloatingRateSpecificationBuilder o = (FloatingRateSpecificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInitialRate(), (RosettaModelObjectBuilder)o.getInitialRate(), this::setInitialRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFinalRateRounding(), (RosettaModelObjectBuilder)o.getFinalRateRounding(), this::setFinalRateRounding);
            merger.mergeBasic((Object)this.getAveragingMethod(), (Object)o.getAveragingMethod(), this::setAveragingMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNegativeInterestRateTreatment(), (Object)o.getNegativeInterestRateTreatment(), this::setNegativeInterestRateTreatment, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FloatingRateSpecification _that = (FloatingRateSpecification)this.getType().cast(o);
            if (!Objects.equals(this.initialRate, _that.getInitialRate())) {
                return false;
            }
            if (!Objects.equals(this.finalRateRounding, _that.getFinalRateRounding())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            return Objects.equals((Object)this.negativeInterestRateTreatment, (Object)_that.getNegativeInterestRateTreatment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.initialRate != null ? this.initialRate.hashCode() : 0);
            _result = 31 * _result + (this.finalRateRounding != null ? this.finalRateRounding.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.negativeInterestRateTreatment != null ? ((Object)((Object)this.negativeInterestRateTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FloatingRateSpecificationBuilder {initialRate=" + this.initialRate + ", finalRateRounding=" + this.finalRateRounding + ", averagingMethod=" + (Object)((Object)this.averagingMethod) + ", negativeInterestRateTreatment=" + (Object)((Object)this.negativeInterestRateTreatment) + '}' + " " + super.toString();
        }
    }

    public static interface FloatingRateSpecificationBuilder
    extends FloatingRateSpecification,
    FloatingRate.FloatingRateBuilder {
        public Price.PriceBuilder getOrCreateInitialRate();

        @Override
        public Price.PriceBuilder getInitialRate();

        public Rounding.RoundingBuilder getOrCreateFinalRateRounding();

        @Override
        public Rounding.RoundingBuilder getFinalRateRounding();

        @Override
        public FloatingRateSpecificationBuilder setRateOption(ReferenceWithMetaFloatingRateOption var1);

        @Override
        public FloatingRateSpecificationBuilder setRateOptionValue(FloatingRateOption var1);

        @Override
        public FloatingRateSpecificationBuilder setSpreadSchedule(SpreadSchedule var1);

        @Override
        public FloatingRateSpecificationBuilder setCapRateSchedule(StrikeSchedule var1);

        @Override
        public FloatingRateSpecificationBuilder setFloorRateSchedule(StrikeSchedule var1);

        @Override
        public FloatingRateSpecificationBuilder setMeta(MetaFields var1);

        @Override
        public FloatingRateSpecificationBuilder setFloatingRateMultiplierSchedule(RateSchedule var1);

        @Override
        public FloatingRateSpecificationBuilder setRateTreatment(RateTreatmentEnum var1);

        @Override
        public FloatingRateSpecificationBuilder setCalculationParameters(FloatingRateCalculationParameters var1);

        @Override
        public FloatingRateSpecificationBuilder setFallbackRate(FallbackRateParameters var1);

        public FloatingRateSpecificationBuilder setInitialRate(Price var1);

        public FloatingRateSpecificationBuilder setFinalRateRounding(Rounding var1);

        public FloatingRateSpecificationBuilder setAveragingMethod(AveragingWeightingMethodEnum var1);

        public FloatingRateSpecificationBuilder setNegativeInterestRateTreatment(NegativeInterestRateTreatmentEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("rateOption"), processor, ReferenceWithMetaFloatingRateOption.ReferenceWithMetaFloatingRateOptionBuilder.class, (RosettaModelObjectBuilder)this.getRateOption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadSchedule"), processor, SpreadSchedule.SpreadScheduleBuilder.class, (RosettaModelObjectBuilder)this.getSpreadSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("capRateSchedule"), processor, StrikeSchedule.StrikeScheduleBuilder.class, (RosettaModelObjectBuilder)this.getCapRateSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floorRateSchedule"), processor, StrikeSchedule.StrikeScheduleBuilder.class, (RosettaModelObjectBuilder)this.getFloorRateSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateMultiplierSchedule"), processor, RateSchedule.RateScheduleBuilder.class, (RosettaModelObjectBuilder)this.getFloatingRateMultiplierSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rateTreatment"), RateTreatmentEnum.class, (Object)this.getRateTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationParameters"), processor, FloatingRateCalculationParameters.FloatingRateCalculationParametersBuilder.class, (RosettaModelObjectBuilder)this.getCalculationParameters(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fallbackRate"), processor, FallbackRateParameters.FallbackRateParametersBuilder.class, (RosettaModelObjectBuilder)this.getFallbackRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initialRate"), processor, Price.PriceBuilder.class, this.getInitialRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalRateRounding"), processor, Rounding.RoundingBuilder.class, this.getFinalRateRounding(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("averagingMethod"), AveragingWeightingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("negativeInterestRateTreatment"), NegativeInterestRateTreatmentEnum.class, (Object)this.getNegativeInterestRateTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public FloatingRateSpecificationBuilder prune();
    }

    public static class FloatingRateSpecificationImpl
    extends FloatingRate.FloatingRateImpl
    implements FloatingRateSpecification {
        private final Price initialRate;
        private final Rounding finalRateRounding;
        private final AveragingWeightingMethodEnum averagingMethod;
        private final NegativeInterestRateTreatmentEnum negativeInterestRateTreatment;

        protected FloatingRateSpecificationImpl(FloatingRateSpecificationBuilder builder) {
            super(builder);
            this.initialRate = Optional.ofNullable(builder.getInitialRate()).map(f -> f.build()).orElse(null);
            this.finalRateRounding = Optional.ofNullable(builder.getFinalRateRounding()).map(f -> f.build()).orElse(null);
            this.averagingMethod = builder.getAveragingMethod();
            this.negativeInterestRateTreatment = builder.getNegativeInterestRateTreatment();
        }

        @Override
        @RosettaAttribute(value="initialRate")
        @RuneAttribute(value="initialRate")
        public Price getInitialRate() {
            return this.initialRate;
        }

        @Override
        @RosettaAttribute(value="finalRateRounding")
        @RuneAttribute(value="finalRateRounding")
        public Rounding getFinalRateRounding() {
            return this.finalRateRounding;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public AveragingWeightingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="negativeInterestRateTreatment")
        @RuneAttribute(value="negativeInterestRateTreatment")
        public NegativeInterestRateTreatmentEnum getNegativeInterestRateTreatment() {
            return this.negativeInterestRateTreatment;
        }

        @Override
        public FloatingRateSpecification build() {
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder toBuilder() {
            FloatingRateSpecificationBuilder builder = FloatingRateSpecification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateSpecificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInitialRate()).ifPresent(builder::setInitialRate);
            Optional.ofNullable(this.getFinalRateRounding()).ifPresent(builder::setFinalRateRounding);
            Optional.ofNullable(this.getAveragingMethod()).ifPresent(builder::setAveragingMethod);
            Optional.ofNullable(this.getNegativeInterestRateTreatment()).ifPresent(builder::setNegativeInterestRateTreatment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FloatingRateSpecification _that = (FloatingRateSpecification)this.getType().cast(o);
            if (!Objects.equals(this.initialRate, _that.getInitialRate())) {
                return false;
            }
            if (!Objects.equals(this.finalRateRounding, _that.getFinalRateRounding())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            return Objects.equals((Object)this.negativeInterestRateTreatment, (Object)_that.getNegativeInterestRateTreatment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.initialRate != null ? this.initialRate.hashCode() : 0);
            _result = 31 * _result + (this.finalRateRounding != null ? this.finalRateRounding.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.negativeInterestRateTreatment != null ? ((Object)((Object)this.negativeInterestRateTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FloatingRateSpecification {initialRate=" + this.initialRate + ", finalRateRounding=" + this.finalRateRounding + ", averagingMethod=" + (Object)((Object)this.averagingMethod) + ", negativeInterestRateTreatment=" + (Object)((Object)this.negativeInterestRateTreatment) + '}' + " " + super.toString();
        }
    }
}

