/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.base.datetime.CalculationPeriodFrequency;
import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.daycount.functions.YearFraction;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.functions.PeriodsInYear;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=CalculateYearFractionDefault.class)
public abstract class CalculateYearFraction
implements RosettaFunction {
    @Inject
    protected PeriodsInYear periodsInYear0;
    @Inject
    protected YearFraction yearFraction;

    public BigDecimal evaluate(InterestRatePayout interestRatePayout, DayCountFractionEnum dcf, CalculationPeriodBase calculationPeriod) {
        BigDecimal yearFrac = this.doEvaluate(interestRatePayout, dcf, calculationPeriod);
        return yearFrac;
    }

    protected abstract BigDecimal doEvaluate(InterestRatePayout var1, DayCountFractionEnum var2, CalculationPeriodBase var3);

    protected abstract MapperS<Date> start(InterestRatePayout var1, DayCountFractionEnum var2, CalculationPeriodBase var3);

    protected abstract MapperS<Date> end(InterestRatePayout var1, DayCountFractionEnum var2, CalculationPeriodBase var3);

    protected abstract MapperS<Date> termination(InterestRatePayout var1, DayCountFractionEnum var2, CalculationPeriodBase var3);

    protected abstract MapperS<Integer> periodsInYear1(InterestRatePayout var1, DayCountFractionEnum var2, CalculationPeriodBase var3);

    public static class CalculateYearFractionDefault
    extends CalculateYearFraction {
        @Override
        protected BigDecimal doEvaluate(InterestRatePayout interestRatePayout, DayCountFractionEnum dcf, CalculationPeriodBase calculationPeriod) {
            BigDecimal yearFrac = null;
            return this.assignOutput(yearFrac, interestRatePayout, dcf, calculationPeriod);
        }

        protected BigDecimal assignOutput(BigDecimal yearFrac, InterestRatePayout interestRatePayout, DayCountFractionEnum dcf, CalculationPeriodBase calculationPeriod) {
            yearFrac = this.yearFraction.evaluate(dcf, (Date)this.start(interestRatePayout, dcf, calculationPeriod).get(), (Date)this.end(interestRatePayout, dcf, calculationPeriod).get(), (Date)this.termination(interestRatePayout, dcf, calculationPeriod).get(), (Integer)this.periodsInYear1(interestRatePayout, dcf, calculationPeriod).get());
            return yearFrac;
        }

        @Override
        protected MapperS<Date> start(InterestRatePayout interestRatePayout, DayCountFractionEnum dcf, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)calculationPeriod).map("getAdjustedStartDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedStartDate());
        }

        @Override
        protected MapperS<Date> end(InterestRatePayout interestRatePayout, DayCountFractionEnum dcf, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)calculationPeriod).map("getAdjustedEndDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedEndDate());
        }

        @Override
        protected MapperS<Date> termination(InterestRatePayout interestRatePayout, DayCountFractionEnum dcf, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)interestRatePayout).map("getCalculationPeriodDates", _interestRatePayout -> _interestRatePayout.getCalculationPeriodDates()).map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate());
        }

        @Override
        protected MapperS<Integer> periodsInYear1(InterestRatePayout interestRatePayout, DayCountFractionEnum dcf, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.periodsInYear0.evaluate((CalculationPeriodFrequency)MapperS.of((Object)interestRatePayout).map("getCalculationPeriodDates", _interestRatePayout -> _interestRatePayout.getCalculationPeriodDates()).map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).get()));
        }
    }
}

