/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.calculation.functions.ApplyFloatingRateSetting;
import cdm.product.asset.floatingrate.FloatingAmountCalculationDetails;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.asset.floatingrate.functions.DetermineFloatingRateReset;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=FloatingAmountCalculationDefault.class)
public abstract class FloatingAmountCalculation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ApplyFloatingRateSetting applyFloatingRateSetting;
    @Inject
    protected DetermineFloatingRateReset determineFloatingRateReset;

    public FloatingAmountCalculationDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate) {
        FloatingAmountCalculationDetails result;
        FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder resultBuilder = this.doEvaluate(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate);
        if (resultBuilder == null) {
            result = null;
        } else {
            result = resultBuilder.build();
            this.objectValidator.validate(FloatingAmountCalculationDetails.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5);

    protected abstract MapperS<? extends FloatingRateSettingDetails> floatingRateSetting(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5);

    public static class FloatingAmountCalculationDefault
    extends FloatingAmountCalculation {
        @Override
        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate) {
            FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result = FloatingAmountCalculationDetails.builder();
            return this.assignOutput(result, interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate);
        }

        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder assignOutput(FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate) {
            result = (FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder)this.toBuilder(this.applyFloatingRateSetting.evaluate(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, (FloatingRateSettingDetails)this.floatingRateSetting(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate).get()));
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends FloatingRateSettingDetails> floatingRateSetting(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)suppliedRate)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.determineFloatingRateReset.evaluate(interestRatePayout, calculationPeriod));
            }
            return MapperS.ofNull();
        }
    }
}

