/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.functions;

import cdm.base.datetime.PeriodRange;
import cdm.product.collateral.CheckEligibilityResult;
import cdm.product.collateral.EligibilityQuery;
import cdm.product.collateral.EligibleCollateralCriteria;
import cdm.product.collateral.EligibleCollateralSpecification;
import cdm.product.collateral.functions.CheckAgencyRating;
import cdm.product.collateral.functions.CheckAssetCountryOfOrigin;
import cdm.product.collateral.functions.CheckAssetType;
import cdm.product.collateral.functions.CheckDenominatedCurrency;
import cdm.product.collateral.functions.CheckIssuerName;
import cdm.product.collateral.functions.CheckIssuerType;
import cdm.product.collateral.functions.CheckMaturity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CheckEligibilityByDetailsDefault.class)
public abstract class CheckEligibilityByDetails
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CheckAgencyRating checkAgencyRating;
    @Inject
    protected CheckAssetCountryOfOrigin checkAssetCountryOfOrigin;
    @Inject
    protected CheckAssetType checkAssetType;
    @Inject
    protected CheckDenominatedCurrency checkDenominatedCurrency;
    @Inject
    protected CheckIssuerName checkIssuerName;
    @Inject
    protected CheckIssuerType checkIssuerType;
    @Inject
    protected CheckMaturity checkMaturity;

    public CheckEligibilityResult evaluate(EligibleCollateralSpecification specification, EligibilityQuery query) {
        CheckEligibilityResult eligibilityResult;
        CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResultBuilder = this.doEvaluate(specification, query);
        if (eligibilityResultBuilder == null) {
            eligibilityResult = null;
        } else {
            eligibilityResult = eligibilityResultBuilder.build();
            this.objectValidator.validate(CheckEligibilityResult.class, (RosettaModelObject)eligibilityResult);
        }
        return eligibilityResult;
    }

    protected abstract CheckEligibilityResult.CheckEligibilityResultBuilder doEvaluate(EligibleCollateralSpecification var1, EligibilityQuery var2);

    protected abstract MapperC<? extends EligibleCollateralCriteria> matchingEligibleCriteria(EligibleCollateralSpecification var1, EligibilityQuery var2);

    public static class CheckEligibilityByDetailsDefault
    extends CheckEligibilityByDetails {
        @Override
        protected CheckEligibilityResult.CheckEligibilityResultBuilder doEvaluate(EligibleCollateralSpecification specification, EligibilityQuery query) {
            CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResult = CheckEligibilityResult.builder();
            return this.assignOutput(eligibilityResult, specification, query);
        }

        protected CheckEligibilityResult.CheckEligibilityResultBuilder assignOutput(CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResult, EligibleCollateralSpecification specification, EligibilityQuery query) {
            eligibilityResult.setIsEligible(ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.matchingEligibleCriteria(specification, query).resultCount()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).get());
            eligibilityResult.setEligibilityQuery(query);
            eligibilityResult.setSpecification(specification);
            eligibilityResult.addMatchingEligibleCriteria(this.matchingEligibleCriteria(specification, query).getMulti());
            return Optional.ofNullable(eligibilityResult).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends EligibleCollateralCriteria> matchingEligibleCriteria(EligibleCollateralSpecification specification, EligibilityQuery query) {
            MapperC thenArg0 = MapperS.of((Object)specification).mapC("getCriteria", eligibleCollateralSpecification -> eligibleCollateralSpecification.getCriteria()).filterItemNullSafe(item -> (Boolean)item.map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getIsIncluded", collateralTreatment -> collateralTreatment.getIsIncluded()).get());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> {
                MapperC _thenArg0 = item.mapC("getAsset", eligibleCollateralCriteria -> eligibleCollateralCriteria.getAsset());
                MapperC _thenArg1 = _thenArg0.filterItemNullSafe(_item -> this.checkAssetCountryOfOrigin.evaluate(_item.mapC("getAssetCountryOfOrigin", assetCriteria -> assetCriteria.getAssetCountryOfOrigin()).getMulti(), query));
                MapperC thenArg2 = _thenArg1.filterItemNullSafe(_item -> this.checkAgencyRating.evaluate(_item.mapC("getAgencyRating", assetCriteria -> assetCriteria.getAgencyRating()).getMulti(), query));
                MapperC thenArg3 = thenArg2.filterItemNullSafe(_item -> this.checkAssetType.evaluate(_item.mapC("getCollateralAssetType", assetCriteria -> assetCriteria.getCollateralAssetType()).getMulti(), query));
                MapperC thenArg4 = thenArg3.filterItemNullSafe(_item -> this.checkDenominatedCurrency.evaluate(_item.mapC("getDenominatedCurrency", assetCriteria -> assetCriteria.getDenominatedCurrency()).getMulti(), query));
                MapperC thenArg5 = thenArg4.filterItemNullSafe(_item -> this.checkMaturity.evaluate((PeriodRange)_item.map("getMaturityRange", assetCriteria -> assetCriteria.getMaturityRange()).get(), query));
                return (Boolean)ExpressionOperatorsNullSafe.exists((Mapper)thenArg5).asMapper().get();
            });
            return thenArg1.filterItemNullSafe(item -> {
                MapperC _thenArg0 = item.mapC("getIssuer", eligibleCollateralCriteria -> eligibleCollateralCriteria.getIssuer());
                MapperC _thenArg1 = _thenArg0.filterItemNullSafe(_item -> this.checkIssuerName.evaluate(_item.mapC("getIssuerName", issuerCriteria -> issuerCriteria.getIssuerName()).getMulti(), query));
                MapperC thenArg2 = _thenArg1.filterItemNullSafe(_item -> this.checkIssuerType.evaluate(_item.mapC("getIssuerType", issuerCriteria -> issuerCriteria.getIssuerType()).getMulti(), query));
                return (Boolean)ExpressionOperatorsNullSafe.exists((Mapper)thenArg2).asMapper().get();
            });
        }
    }
}

