/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.PrincipalPayment;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PrincipalPaymentDiscountFactor")
@ImplementedBy(value=Default.class)
public interface PrincipalPaymentDiscountFactor
extends Validator<PrincipalPayment> {
    public static final String NAME = "PrincipalPaymentDiscountFactor";
    public static final String DEFINITION = "if presentValuePrincipalAmount exists then discountFactor exists";

    public static class NoOp
    implements PrincipalPaymentDiscountFactor {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PrincipalPayment principalPayment) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PrincipalPaymentDiscountFactor {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PrincipalPayment principalPayment) {
            ComparisonResult result = this.executeDataRule(principalPayment);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PrincipalPaymentDiscountFactor.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PrincipalPayment", (RosettaPath)path, (String)PrincipalPaymentDiscountFactor.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PrincipalPaymentDiscountFactor.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PrincipalPayment", (RosettaPath)path, (String)PrincipalPaymentDiscountFactor.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PrincipalPayment principalPayment) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)principalPayment).map("getPresentValuePrincipalAmount", _principalPayment -> _principalPayment.getPresentValuePrincipalAmount())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)principalPayment).map("getDiscountFactor", _principalPayment -> _principalPayment.getDiscountFactor()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

