/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.observable.event.TriggerEvent;
import cdm.product.template.meta.BarrierMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Barrier", builder=BarrierBuilderImpl.class, version="5.31.0")
@RuneDataType(value="Barrier", model="cdm", builder=BarrierBuilderImpl.class, version="5.31.0")
public interface Barrier
extends RosettaModelObject {
    public static final BarrierMeta metaData = new BarrierMeta();

    public List<? extends TriggerEvent> getBarrierCap();

    public List<? extends TriggerEvent> getBarrierFloor();

    public Barrier build();

    public BarrierBuilder toBuilder();

    public static BarrierBuilder builder() {
        return new BarrierBuilderImpl();
    }

    default public RosettaMetaData<? extends Barrier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Barrier> getType() {
        return Barrier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("barrierCap"), processor, TriggerEvent.class, this.getBarrierCap(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrierFloor"), processor, TriggerEvent.class, this.getBarrierFloor(), new AttributeMeta[0]);
    }

    public static class BarrierBuilderImpl
    implements BarrierBuilder {
        protected List<TriggerEvent.TriggerEventBuilder> barrierCap = new ArrayList<TriggerEvent.TriggerEventBuilder>();
        protected List<TriggerEvent.TriggerEventBuilder> barrierFloor = new ArrayList<TriggerEvent.TriggerEventBuilder>();

        @Override
        @RosettaAttribute(value="barrierCap")
        @RuneAttribute(value="barrierCap")
        public List<? extends TriggerEvent.TriggerEventBuilder> getBarrierCap() {
            return this.barrierCap;
        }

        @Override
        public TriggerEvent.TriggerEventBuilder getOrCreateBarrierCap(int index) {
            if (this.barrierCap == null) {
                this.barrierCap = new ArrayList<TriggerEvent.TriggerEventBuilder>();
            }
            return (TriggerEvent.TriggerEventBuilder)this.getIndex(this.barrierCap, index, () -> {
                TriggerEvent.TriggerEventBuilder newBarrierCap = TriggerEvent.builder();
                return newBarrierCap;
            });
        }

        @Override
        @RosettaAttribute(value="barrierFloor")
        @RuneAttribute(value="barrierFloor")
        public List<? extends TriggerEvent.TriggerEventBuilder> getBarrierFloor() {
            return this.barrierFloor;
        }

        @Override
        public TriggerEvent.TriggerEventBuilder getOrCreateBarrierFloor(int index) {
            if (this.barrierFloor == null) {
                this.barrierFloor = new ArrayList<TriggerEvent.TriggerEventBuilder>();
            }
            return (TriggerEvent.TriggerEventBuilder)this.getIndex(this.barrierFloor, index, () -> {
                TriggerEvent.TriggerEventBuilder newBarrierFloor = TriggerEvent.builder();
                return newBarrierFloor;
            });
        }

        @Override
        @RosettaAttribute(value="barrierCap")
        @RuneAttribute(value="barrierCap")
        public BarrierBuilder addBarrierCap(TriggerEvent _barrierCap) {
            if (_barrierCap != null) {
                this.barrierCap.add(_barrierCap.toBuilder());
            }
            return this;
        }

        @Override
        public BarrierBuilder addBarrierCap(TriggerEvent _barrierCap, int idx) {
            this.getIndex(this.barrierCap, idx, () -> _barrierCap.toBuilder());
            return this;
        }

        @Override
        public BarrierBuilder addBarrierCap(List<? extends TriggerEvent> barrierCaps) {
            if (barrierCaps != null) {
                for (TriggerEvent triggerEvent : barrierCaps) {
                    this.barrierCap.add(triggerEvent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="barrierCap")
        public BarrierBuilder setBarrierCap(List<? extends TriggerEvent> barrierCaps) {
            this.barrierCap = barrierCaps == null ? new ArrayList<TriggerEvent.TriggerEventBuilder>() : (List)barrierCaps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="barrierFloor")
        @RuneAttribute(value="barrierFloor")
        public BarrierBuilder addBarrierFloor(TriggerEvent _barrierFloor) {
            if (_barrierFloor != null) {
                this.barrierFloor.add(_barrierFloor.toBuilder());
            }
            return this;
        }

        @Override
        public BarrierBuilder addBarrierFloor(TriggerEvent _barrierFloor, int idx) {
            this.getIndex(this.barrierFloor, idx, () -> _barrierFloor.toBuilder());
            return this;
        }

        @Override
        public BarrierBuilder addBarrierFloor(List<? extends TriggerEvent> barrierFloors) {
            if (barrierFloors != null) {
                for (TriggerEvent triggerEvent : barrierFloors) {
                    this.barrierFloor.add(triggerEvent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="barrierFloor")
        public BarrierBuilder setBarrierFloor(List<? extends TriggerEvent> barrierFloors) {
            this.barrierFloor = barrierFloors == null ? new ArrayList<TriggerEvent.TriggerEventBuilder>() : (List)barrierFloors.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Barrier build() {
            return new BarrierImpl(this);
        }

        @Override
        public BarrierBuilder toBuilder() {
            return this;
        }

        @Override
        public BarrierBuilder prune() {
            this.barrierCap = this.barrierCap.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.barrierFloor = this.barrierFloor.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getBarrierCap() != null && this.getBarrierCap().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getBarrierFloor() != null && this.getBarrierFloor().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public BarrierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BarrierBuilder o = (BarrierBuilder)other;
            merger.mergeRosetta(this.getBarrierCap(), o.getBarrierCap(), this::getOrCreateBarrierCap);
            merger.mergeRosetta(this.getBarrierFloor(), o.getBarrierFloor(), this::getOrCreateBarrierFloor);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Barrier _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.barrierCap, _that.getBarrierCap())) {
                return false;
            }
            return ListEquals.listEquals(this.barrierFloor, _that.getBarrierFloor());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.barrierCap != null ? this.barrierCap.hashCode() : 0);
            _result = 31 * _result + (this.barrierFloor != null ? this.barrierFloor.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BarrierBuilder {barrierCap=" + this.barrierCap + ", barrierFloor=" + this.barrierFloor + '}';
        }
    }

    public static interface BarrierBuilder
    extends Barrier,
    RosettaModelObjectBuilder {
        public TriggerEvent.TriggerEventBuilder getOrCreateBarrierCap(int var1);

        public List<? extends TriggerEvent.TriggerEventBuilder> getBarrierCap();

        public TriggerEvent.TriggerEventBuilder getOrCreateBarrierFloor(int var1);

        public List<? extends TriggerEvent.TriggerEventBuilder> getBarrierFloor();

        public BarrierBuilder addBarrierCap(TriggerEvent var1);

        public BarrierBuilder addBarrierCap(TriggerEvent var1, int var2);

        public BarrierBuilder addBarrierCap(List<? extends TriggerEvent> var1);

        public BarrierBuilder setBarrierCap(List<? extends TriggerEvent> var1);

        public BarrierBuilder addBarrierFloor(TriggerEvent var1);

        public BarrierBuilder addBarrierFloor(TriggerEvent var1, int var2);

        public BarrierBuilder addBarrierFloor(List<? extends TriggerEvent> var1);

        public BarrierBuilder setBarrierFloor(List<? extends TriggerEvent> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("barrierCap"), processor, TriggerEvent.TriggerEventBuilder.class, this.getBarrierCap(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrierFloor"), processor, TriggerEvent.TriggerEventBuilder.class, this.getBarrierFloor(), new AttributeMeta[0]);
        }

        public BarrierBuilder prune();
    }

    public static class BarrierImpl
    implements Barrier {
        private final List<? extends TriggerEvent> barrierCap;
        private final List<? extends TriggerEvent> barrierFloor;

        protected BarrierImpl(BarrierBuilder builder) {
            this.barrierCap = Optional.ofNullable(builder.getBarrierCap()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.barrierFloor = Optional.ofNullable(builder.getBarrierFloor()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="barrierCap")
        @RuneAttribute(value="barrierCap")
        public List<? extends TriggerEvent> getBarrierCap() {
            return this.barrierCap;
        }

        @Override
        @RosettaAttribute(value="barrierFloor")
        @RuneAttribute(value="barrierFloor")
        public List<? extends TriggerEvent> getBarrierFloor() {
            return this.barrierFloor;
        }

        @Override
        public Barrier build() {
            return this;
        }

        @Override
        public BarrierBuilder toBuilder() {
            BarrierBuilder builder = Barrier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BarrierBuilder builder) {
            Optional.ofNullable(this.getBarrierCap()).ifPresent(builder::setBarrierCap);
            Optional.ofNullable(this.getBarrierFloor()).ifPresent(builder::setBarrierFloor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Barrier _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.barrierCap, _that.getBarrierCap())) {
                return false;
            }
            return ListEquals.listEquals(this.barrierFloor, _that.getBarrierFloor());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.barrierCap != null ? this.barrierCap.hashCode() : 0);
            _result = 31 * _result + (this.barrierFloor != null ? this.barrierFloor.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Barrier {barrierCap=" + this.barrierCap + ", barrierFloor=" + this.barrierFloor + '}';
        }
    }
}

