/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Basket;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="BasketChoice0")
@ImplementedBy(value=Default.class)
public interface BasketChoice0
extends Validator<Basket> {
    public static final String NAME = "BasketChoice0";
    public static final String DEFINITION = "required choice basketConstituent, portfolioBasketConstituent";

    public static class NoOp
    implements BasketChoice0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Basket basket) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements BasketChoice0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Basket basket) {
            ComparisonResult result = this.executeDataRule(basket);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)BasketChoice0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Basket", (RosettaPath)path, (String)BasketChoice0.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)BasketChoice0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Basket", (RosettaPath)path, (String)BasketChoice0.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Basket basket) {
            try {
                return ExpressionOperatorsNullSafe.choice((Mapper)MapperS.of((Object)basket), Arrays.asList("basketConstituent", "portfolioBasketConstituent"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

