/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.ConstituentWeight;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ConstituentWeightBasketPercentage")
@ImplementedBy(value=Default.class)
public interface ConstituentWeightBasketPercentage
extends Validator<ConstituentWeight> {
    public static final String NAME = "ConstituentWeightBasketPercentage";
    public static final String DEFINITION = "if basketPercentage exists then basketPercentage >= 0.0 and basketPercentage <= 1.0";

    public static class NoOp
    implements ConstituentWeightBasketPercentage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ConstituentWeight constituentWeight) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ConstituentWeightBasketPercentage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ConstituentWeight constituentWeight) {
            ComparisonResult result = this.executeDataRule(constituentWeight);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ConstituentWeightBasketPercentage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ConstituentWeight", (RosettaPath)path, (String)ConstituentWeightBasketPercentage.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ConstituentWeightBasketPercentage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ConstituentWeight", (RosettaPath)path, (String)ConstituentWeightBasketPercentage.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ConstituentWeight constituentWeight) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)constituentWeight).map("getBasketPercentage", _constituentWeight -> _constituentWeight.getBasketPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)MapperS.of((Object)constituentWeight).map("getBasketPercentage", _constituentWeight -> _constituentWeight.getBasketPercentage()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)constituentWeight).map("getBasketPercentage", _constituentWeight -> _constituentWeight.getBasketPercentage()), (Mapper)MapperS.of((Object)new BigDecimal("1.0")), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

