/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="EconomicTermsAssetPayoutDividendTermsValidation")
@ImplementedBy(value=Default.class)
public interface EconomicTermsAssetPayoutDividendTermsValidation
extends Validator<EconomicTerms> {
    public static final String NAME = "EconomicTermsAssetPayoutDividendTermsValidation";
    public static final String DEFINITION = "if payout -> assetPayout -> dividendTerms exists then terminationDate exists";

    public static class NoOp
    implements EconomicTermsAssetPayoutDividendTermsValidation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EconomicTerms economicTerms) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EconomicTermsAssetPayoutDividendTermsValidation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EconomicTerms economicTerms) {
            ComparisonResult result = this.executeDataRule(economicTerms);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EconomicTermsAssetPayoutDividendTermsValidation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsAssetPayoutDividendTermsValidation.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EconomicTermsAssetPayoutDividendTermsValidation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsAssetPayoutDividendTermsValidation.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EconomicTerms economicTerms) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout()).map("getDividendTerms", assetPayout -> assetPayout.getDividendTerms())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)economicTerms).map("getTerminationDate", _economicTerms -> _economicTerms.getTerminationDate()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

