/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradableProductExerciseNoticeReceiverPartyCancelableProvision")
@ImplementedBy(value=Default.class)
public interface TradableProductExerciseNoticeReceiverPartyCancelableProvision
extends Validator<TradableProduct> {
    public static final String NAME = "TradableProductExerciseNoticeReceiverPartyCancelableProvision";
    public static final String DEFINITION = "if product -> contractualProduct -> economicTerms -> terminationProvision -> cancelableProvision -> exerciseNotice -> exerciseNoticeReceiver exists then ancillaryParty -> role contains AncillaryRoleEnum -> ExerciseNoticeReceiverPartyCancelableProvision and if ancillaryParty -> role contains AncillaryRoleEnum -> ExerciseNoticeReceiverPartyCancelableProvision then product -> contractualProduct -> economicTerms -> terminationProvision -> cancelableProvision -> exerciseNotice -> exerciseNoticeReceiver exists";

    public static class NoOp
    implements TradableProductExerciseNoticeReceiverPartyCancelableProvision {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradableProduct tradableProduct) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradableProductExerciseNoticeReceiverPartyCancelableProvision {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradableProduct tradableProduct) {
            ComparisonResult result = this.executeDataRule(tradableProduct);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradableProductExerciseNoticeReceiverPartyCancelableProvision.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductExerciseNoticeReceiverPartyCancelableProvision.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradableProductExerciseNoticeReceiverPartyCancelableProvision.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductExerciseNoticeReceiverPartyCancelableProvision.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TradableProduct tradableProduct) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()).map("getCancelableProvision", terminationProvision -> terminationProvision.getCancelableProvision()).map("getExerciseNotice", cancelableProvision -> cancelableProvision.getExerciseNotice()).map("getExerciseNoticeReceiver", exerciseNotice -> exerciseNotice.getExerciseNoticeReceiver())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult = ExpressionOperatorsNullSafe.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.EXERCISE_NOTICE_RECEIVER_PARTY_CANCELABLE_PROVISION))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()).map("getCancelableProvision", terminationProvision -> terminationProvision.getCancelableProvision()).map("getExerciseNotice", cancelableProvision -> cancelableProvision.getExerciseNotice()).map("getExerciseNoticeReceiver", exerciseNotice -> exerciseNotice.getExerciseNoticeReceiver())) : ComparisonResult.ofEmpty();
                    return ExpressionOperatorsNullSafe.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.EXERCISE_NOTICE_RECEIVER_PARTY_CANCELABLE_PROVISION))).andNullSafe(ifThenElseResult);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

