package iso20022.auth030.esma.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.esma.TradeConfirmation1Choice;
import iso20022.auth030.esma.validation.TradeConfirmation1ChoiceTypeFormatValidator;
import iso20022.auth030.esma.validation.TradeConfirmation1ChoiceValidator;
import iso20022.auth030.esma.validation.exists.TradeConfirmation1ChoiceOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version ${project.version}
 */
@RosettaMeta(model=TradeConfirmation1Choice.class)
public class TradeConfirmation1ChoiceMeta implements RosettaMetaData<TradeConfirmation1Choice> {

	@Override
	public List<Validator<? super TradeConfirmation1Choice>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<iso20022.auth030.esma.TradeConfirmation1Choice>create(iso20022.auth030.esma.validation.datarule.TradeConfirmation1ChoiceChoice.class)
		);
	}
	
	@Override
	public List<Function<? super TradeConfirmation1Choice, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}

	@Override
	public Validator<? super TradeConfirmation1Choice> validator() {
		return new TradeConfirmation1ChoiceValidator();
	}

	@Override
	public Validator<? super TradeConfirmation1Choice> typeFormatValidator() {
		return new TradeConfirmation1ChoiceTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super TradeConfirmation1Choice, Set<String>> onlyExistsValidator() {
		return new TradeConfirmation1ChoiceOnlyExistsValidator();
	}
}
