package iso20022.auth030.esma.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.esma.TradeTransaction49__1;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class TradeTransaction49__1TypeFormatValidator implements Validator<TradeTransaction49__1> {

	private List<ComparisonResult> getComparisonResults(TradeTransaction49__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("rptTrckgNb", o.getRptTrckgNb(), 1, of(52), empty()), 
				checkString("pltfmIdr", o.getPltfmIdr(), 0, empty(), of(Pattern.compile("[A-Z0-9]{4,4}")))
			);
	}

	@Override
	public ValidationResult<TradeTransaction49__1> validate(RosettaPath path, TradeTransaction49__1 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("TradeTransaction49__1", ValidationType.TYPE_FORMAT, "TradeTransaction49__1", path, "", error);
		}
		return success("TradeTransaction49__1", ValidationType.TYPE_FORMAT, "TradeTransaction49__1", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeTransaction49__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("TradeTransaction49__1", ValidationType.TYPE_FORMAT, "TradeTransaction49__1", path, "", res.getError());
				}
				return success("TradeTransaction49__1", ValidationType.TYPE_FORMAT, "TradeTransaction49__1", path, "");
			})
			.collect(toList());
	}

}
