package iso20022.auth030.fca.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.fca.SecuritiesTransactionPrice20Choice__1;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("SecuritiesTransactionPrice20Choice__1Choice")
@ImplementedBy(SecuritiesTransactionPrice20Choice1Choice.Default.class)
public interface SecuritiesTransactionPrice20Choice1Choice extends Validator<SecuritiesTransactionPrice20Choice__1> {
	
	String NAME = "SecuritiesTransactionPrice20Choice__1Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<SecuritiesTransactionPrice20Choice__1> validate(RosettaPath path, SecuritiesTransactionPrice20Choice__1 securitiesTransactionPrice20Choice__1);
	
	class Default implements SecuritiesTransactionPrice20Choice1Choice {
	
		@Override
		public ValidationResult<SecuritiesTransactionPrice20Choice__1> validate(RosettaPath path, SecuritiesTransactionPrice20Choice__1 securitiesTransactionPrice20Choice__1) {
			ComparisonResult result = executeDataRule(securitiesTransactionPrice20Choice__1);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SecuritiesTransactionPrice20Choice__1", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "SecuritiesTransactionPrice20Choice__1", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(SecuritiesTransactionPrice20Choice__1 securitiesTransactionPrice20Choice__1) {
			try {
				return choice(MapperS.of(securitiesTransactionPrice20Choice__1), Arrays.asList("mntryVal", "pctg", "bsisPtSprd"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SecuritiesTransactionPrice20Choice1Choice {
	
		@Override
		public ValidationResult<SecuritiesTransactionPrice20Choice__1> validate(RosettaPath path, SecuritiesTransactionPrice20Choice__1 securitiesTransactionPrice20Choice__1) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SecuritiesTransactionPrice20Choice__1", path, DEFINITION);
		}
	}
}
