package iso20022.auth030.hkma.tr;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.tr.AssetClassDetailedSubProductType32Code;
import iso20022.auth030.hkma.tr.AssetClassProductType2Code;
import iso20022.auth030.hkma.tr.AssetClassSubProductType8Code;
import iso20022.auth030.hkma.tr.EnergyCommodityOil3;
import iso20022.auth030.hkma.tr.EnergyCommodityOil3.EnergyCommodityOil3Builder;
import iso20022.auth030.hkma.tr.EnergyCommodityOil3.EnergyCommodityOil3BuilderImpl;
import iso20022.auth030.hkma.tr.EnergyCommodityOil3.EnergyCommodityOil3Impl;
import iso20022.auth030.hkma.tr.meta.EnergyCommodityOil3Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an energy derivative of type oil.
 * @version ${project.version}
 */
@RosettaDataType(value="EnergyCommodityOil3", builder=EnergyCommodityOil3.EnergyCommodityOil3BuilderImpl.class, version="${project.version}")
public interface EnergyCommodityOil3 extends RosettaModelObject {

	EnergyCommodityOil3Meta metaData = new EnergyCommodityOil3Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType2Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType8Code getSubPdct();
	/**
	 * Further subproduct type related to instruments that have a non-financial instrument or commodity as underlying.
	 */
	AssetClassDetailedSubProductType32Code getAddtlSubPdct();

	/*********************** Build Methods  ***********************/
	EnergyCommodityOil3 build();
	
	EnergyCommodityOil3.EnergyCommodityOil3Builder toBuilder();
	
	static EnergyCommodityOil3.EnergyCommodityOil3Builder builder() {
		return new EnergyCommodityOil3.EnergyCommodityOil3BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends EnergyCommodityOil3> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends EnergyCommodityOil3> getType() {
		return EnergyCommodityOil3.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType8Code.class, getSubPdct(), this);
		processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType32Code.class, getAddtlSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface EnergyCommodityOil3Builder extends EnergyCommodityOil3, RosettaModelObjectBuilder {
		EnergyCommodityOil3.EnergyCommodityOil3Builder setBasePdct(AssetClassProductType2Code basePdct);
		EnergyCommodityOil3.EnergyCommodityOil3Builder setSubPdct(AssetClassSubProductType8Code subPdct);
		EnergyCommodityOil3.EnergyCommodityOil3Builder setAddtlSubPdct(AssetClassDetailedSubProductType32Code addtlSubPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType8Code.class, getSubPdct(), this);
			processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType32Code.class, getAddtlSubPdct(), this);
		}
		

		EnergyCommodityOil3.EnergyCommodityOil3Builder prune();
	}

	/*********************** Immutable Implementation of EnergyCommodityOil3  ***********************/
	class EnergyCommodityOil3Impl implements EnergyCommodityOil3 {
		private final AssetClassProductType2Code basePdct;
		private final AssetClassSubProductType8Code subPdct;
		private final AssetClassDetailedSubProductType32Code addtlSubPdct;
		
		protected EnergyCommodityOil3Impl(EnergyCommodityOil3.EnergyCommodityOil3Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
			this.addtlSubPdct = builder.getAddtlSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType8Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType32Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		public EnergyCommodityOil3 build() {
			return this;
		}
		
		@Override
		public EnergyCommodityOil3.EnergyCommodityOil3Builder toBuilder() {
			EnergyCommodityOil3.EnergyCommodityOil3Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(EnergyCommodityOil3.EnergyCommodityOil3Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
			ofNullable(getAddtlSubPdct()).ifPresent(builder::setAddtlSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityOil3 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityOil3 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of EnergyCommodityOil3  ***********************/
	class EnergyCommodityOil3BuilderImpl implements EnergyCommodityOil3.EnergyCommodityOil3Builder {
	
		protected AssetClassProductType2Code basePdct;
		protected AssetClassSubProductType8Code subPdct;
		protected AssetClassDetailedSubProductType32Code addtlSubPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType8Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType32Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public EnergyCommodityOil3.EnergyCommodityOil3Builder setBasePdct(AssetClassProductType2Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public EnergyCommodityOil3.EnergyCommodityOil3Builder setSubPdct(AssetClassSubProductType8Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public EnergyCommodityOil3.EnergyCommodityOil3Builder setAddtlSubPdct(AssetClassDetailedSubProductType32Code _addtlSubPdct) {
			this.addtlSubPdct = _addtlSubPdct == null ? null : _addtlSubPdct;
			return this;
		}
		
		@Override
		public EnergyCommodityOil3 build() {
			return new EnergyCommodityOil3.EnergyCommodityOil3Impl(this);
		}
		
		@Override
		public EnergyCommodityOil3.EnergyCommodityOil3Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityOil3.EnergyCommodityOil3Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			if (getAddtlSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityOil3.EnergyCommodityOil3Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			EnergyCommodityOil3.EnergyCommodityOil3Builder o = (EnergyCommodityOil3.EnergyCommodityOil3Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			merger.mergeBasic(getAddtlSubPdct(), o.getAddtlSubPdct(), this::setAddtlSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityOil3 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityOil3Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}
}
