package iso20022.auth108.hkma.dtcc.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth108.hkma.dtcc.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ActiveOrHistoricCurrencyAnd5DecimalAmountOnlyExistsValidator implements ValidatorWithArg<ActiveOrHistoricCurrencyAnd5DecimalAmount, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ActiveOrHistoricCurrencyAnd5DecimalAmount> ValidationResult<ActiveOrHistoricCurrencyAnd5DecimalAmount> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("value", ExistenceChecker.isSet((BigDecimal) o.getValue()))
				.put("ccy", ExistenceChecker.isSet((String) o.getCcy()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ActiveOrHistoricCurrencyAnd5DecimalAmount", ValidationType.ONLY_EXISTS, "ActiveOrHistoricCurrencyAnd5DecimalAmount", path, "");
		}
		return failure("ActiveOrHistoricCurrencyAnd5DecimalAmount", ValidationType.ONLY_EXISTS, "ActiveOrHistoricCurrencyAnd5DecimalAmount", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
