package drr.projection.iso20022.asic.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.BarrierAndNotation;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.asic.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.asic.AmountAndDirection106__1;
import iso20022.auth030.asic.OptionBarrierLevel1Choice__1;
import iso20022.auth030.asic.OptionMultipleBarrierLevels1__1;
import iso20022.auth030.asic.SecuritiesTransactionPrice23Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Create_OptionBarrierLevel1Choice__1.Create_OptionBarrierLevel1Choice__1Default.class)
public abstract class Create_OptionBarrierLevel1Choice__1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Abs abs;

	/**
	* @param drrReport 
	* @return brrrLvls 
	*/
	public OptionBarrierLevel1Choice__1 evaluate(ASICTransactionReport drrReport) {
		OptionBarrierLevel1Choice__1.OptionBarrierLevel1Choice__1Builder brrrLvlsBuilder = doEvaluate(drrReport);
		
		final OptionBarrierLevel1Choice__1 brrrLvls;
		if (brrrLvlsBuilder == null) {
			brrrLvls = null;
		} else {
			brrrLvls = brrrLvlsBuilder.build();
			objectValidator.validate(OptionBarrierLevel1Choice__1.class, brrrLvls);
		}
		
		return brrrLvls;
	}

	protected abstract OptionBarrierLevel1Choice__1.OptionBarrierLevel1Choice__1Builder doEvaluate(ASICTransactionReport drrReport);

	public static class Create_OptionBarrierLevel1Choice__1Default extends Create_OptionBarrierLevel1Choice__1 {
		@Override
		protected OptionBarrierLevel1Choice__1.OptionBarrierLevel1Choice__1Builder doEvaluate(ASICTransactionReport drrReport) {
			OptionBarrierLevel1Choice__1.OptionBarrierLevel1Choice__1Builder brrrLvls = OptionBarrierLevel1Choice__1.builder();
			return assignOutput(brrrLvls, drrReport);
		}
		
		protected OptionBarrierLevel1Choice__1.OptionBarrierLevel1Choice__1Builder assignOutput(OptionBarrierLevel1Choice__1.OptionBarrierLevel1Choice__1Builder brrrLvls, ASICTransactionReport drrReport) {
			brrrLvls = toBuilder(OptionBarrierLevel1Choice__1.builder()
				.setSngl(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", aSICTransactionReport -> aSICTransactionReport.getBarrier())
					.mapSingleToItem(item -> {
						AmountAndDirection106__1 ifThenElseResult1 = null;
						if (areEqual(item.<PriceNotationEnum>map("getSingleBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							Boolean ifThenElseResult0 = null;
							if (lessThan(item.<BigDecimal>map("getSingleBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult0 = false;
							}
							ifThenElseResult1 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
									.setValue(abs.evaluate(item.<BigDecimal>map("getSingleBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceMonetary()).get()))
									.setCcy(item.<ISOCurrencyCodeEnum>map("getSingleBarrierPriceCurrency", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
									.build())
								.setSgn(ifThenElseResult0)
								.build();
						}
						BigDecimal ifThenElseResult2 = null;
						if (areEqual(item.<PriceNotationEnum>map("getSingleBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult2 = item.<BigDecimal>map("getSingleBarrierPriceDecimal", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceDecimal()).get();
						}
						return MapperS.of(SecuritiesTransactionPrice23Choice__1.builder()
							.setMntryVal(ifThenElseResult1)
							.setDcml(ifThenElseResult2)
							.build());
					}).get())
				.setMltpl(OptionMultipleBarrierLevels1__1.builder()
					.setLwrLvl(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", aSICTransactionReport -> aSICTransactionReport.getBarrier())
						.mapSingleToItem(item -> {
							AmountAndDirection106__1 ifThenElseResult1 = null;
							if (areEqual(item.<PriceNotationEnum>map("getLowerBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
								Boolean ifThenElseResult0 = null;
								if (lessThan(item.<BigDecimal>map("getLowerBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
									ifThenElseResult0 = false;
								}
								ifThenElseResult1 = AmountAndDirection106__1.builder()
									.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
										.setValue(abs.evaluate(item.<BigDecimal>map("getLowerBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceMonetary()).get()))
										.setCcy(item.<ISOCurrencyCodeEnum>map("getLowerBarrierPriceCurrency", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
										.build())
									.setSgn(ifThenElseResult0)
									.build();
							}
							BigDecimal ifThenElseResult2 = null;
							if (areEqual(item.<PriceNotationEnum>map("getLowerBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult2 = item.<BigDecimal>map("getLowerBarrierPriceDecimal", barrierAndNotation -> barrierAndNotation.getLowerBarrierPriceDecimal()).get();
							}
							return MapperS.of(SecuritiesTransactionPrice23Choice__1.builder()
								.setMntryVal(ifThenElseResult1)
								.setDcml(ifThenElseResult2)
								.build());
						}).get())
					.setUpperLvl(MapperS.of(drrReport).<BarrierAndNotation>map("getBarrier", aSICTransactionReport -> aSICTransactionReport.getBarrier())
						.mapSingleToItem(item -> {
							AmountAndDirection106__1 ifThenElseResult1 = null;
							if (areEqual(item.<PriceNotationEnum>map("getUpperBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
								Boolean ifThenElseResult0 = null;
								if (lessThan(item.<BigDecimal>map("getUpperBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
									ifThenElseResult0 = false;
								}
								ifThenElseResult1 = AmountAndDirection106__1.builder()
									.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
										.setValue(abs.evaluate(item.<BigDecimal>map("getUpperBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceMonetary()).get()))
										.setCcy(item.<ISOCurrencyCodeEnum>map("getUpperBarrierPriceCurrency", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
										.build())
									.setSgn(ifThenElseResult0)
									.build();
							}
							BigDecimal ifThenElseResult2 = null;
							if (areEqual(item.<PriceNotationEnum>map("getUpperBarrierPriceNotation", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult2 = item.<BigDecimal>map("getUpperBarrierPriceDecimal", barrierAndNotation -> barrierAndNotation.getUpperBarrierPriceDecimal()).get();
							}
							return MapperS.of(SecuritiesTransactionPrice23Choice__1.builder()
								.setMntryVal(ifThenElseResult1)
								.setDcml(ifThenElseResult2)
								.build());
						}).get())
					.build())
				.build());
			
			return Optional.ofNullable(brrrLvls)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
