package drr.projection.iso20022.asic.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.asic.rewrite.trade.NotionalAmountScheduleLeg2Report;
import iso20022.auth030.asic.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.asic.AmountAndDirection106__2;
import iso20022.auth030.asic.NotionalAmount5__1;
import iso20022.auth030.asic.NotionalAmount6__1;
import iso20022.auth030.asic.NotionalAmountLegs5__1;
import iso20022.auth030.asic.Schedule11__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetNtnlAmt.GetNtnlAmtDefault.class)
public abstract class GetNtnlAmt implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Abs abs;

	/**
	* @param drrReport 
	* @return ntnlAmt 
	*/
	public NotionalAmountLegs5__1 evaluate(ASICTransactionReport drrReport) {
		NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmtBuilder = doEvaluate(drrReport);
		
		final NotionalAmountLegs5__1 ntnlAmt;
		if (ntnlAmtBuilder == null) {
			ntnlAmt = null;
		} else {
			ntnlAmt = ntnlAmtBuilder.build();
			objectValidator.validate(NotionalAmountLegs5__1.class, ntnlAmt);
		}
		
		return ntnlAmt;
	}

	protected abstract NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder doEvaluate(ASICTransactionReport drrReport);

	public static class GetNtnlAmtDefault extends GetNtnlAmt {
		@Override
		protected NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder doEvaluate(ASICTransactionReport drrReport) {
			NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmt = NotionalAmountLegs5__1.builder();
			return assignOutput(ntnlAmt, drrReport);
		}
		
		protected NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder assignOutput(NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmt, ASICTransactionReport drrReport) {
			Boolean ifThenElseResult0 = null;
			if (lessThan(MapperS.of(drrReport).<BigDecimal>map("getNotionalLeg1", aSICTransactionReport -> aSICTransactionReport.getNotionalLeg1()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult0 = false;
			}
			Boolean ifThenElseResult1 = null;
			if (lessThan(MapperS.of(drrReport).<BigDecimal>map("getNotionalLeg2", aSICTransactionReport -> aSICTransactionReport.getNotionalLeg2()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = false;
			}
			ntnlAmt = toBuilder(NotionalAmountLegs5__1.builder()
				.setFrstLeg(NotionalAmount5__1.builder()
					.setAmt(AmountAndDirection106__2.builder()
						.setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
							.setValue(abs.evaluate(MapperS.of(drrReport).<BigDecimal>map("getNotionalLeg1", aSICTransactionReport -> aSICTransactionReport.getNotionalLeg1()).get()))
							.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getNotionalCurrencyLeg1", aSICTransactionReport -> aSICTransactionReport.getNotionalCurrencyLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
							.build())
						.setSgn(ifThenElseResult0)
						.build())
					.setSchdlPrd(MapperS.of(drrReport).<NotionalAmountScheduleLeg1Report>mapC("getNotionalAmountScheduleLeg1", aSICTransactionReport -> aSICTransactionReport.getNotionalAmountScheduleLeg1())
						.mapItem(item -> {
							Boolean ifThenElseResult = null;
							if (lessThan(item.<BigDecimal>map("getAmount", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getAmount()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult = false;
							}
							return MapperS.of(Schedule11__1.builder()
								.setUadjstdFctvDt(item.<Date>map("getEffectiveDate", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getEffectiveDate()).get())
								.setAmt(AmountAndDirection106__2.builder()
									.setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
										.setValue(abs.evaluate(item.<BigDecimal>map("getAmount", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getAmount()).get()))
										.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getNotionalCurrencyLeg1", aSICTransactionReport -> aSICTransactionReport.getNotionalCurrencyLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
										.build())
									.setSgn(ifThenElseResult)
									.build())
								.build());
						}).getMulti())
					.build())
				.setScndLeg(NotionalAmount6__1.builder()
					.setAmt(AmountAndDirection106__2.builder()
						.setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
							.setValue(abs.evaluate(MapperS.of(drrReport).<BigDecimal>map("getNotionalLeg2", aSICTransactionReport -> aSICTransactionReport.getNotionalLeg2()).get()))
							.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getNotionalCurrencyLeg2", aSICTransactionReport -> aSICTransactionReport.getNotionalCurrencyLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
							.build())
						.setSgn(ifThenElseResult1)
						.build())
					.setSchdlPrd(MapperS.of(drrReport).<NotionalAmountScheduleLeg2Report>mapC("getNotionalAmountScheduleLeg2", aSICTransactionReport -> aSICTransactionReport.getNotionalAmountScheduleLeg2())
						.mapItem(item -> {
							Boolean ifThenElseResult = null;
							if (lessThan(item.<BigDecimal>map("getAmount", notionalAmountScheduleLeg2Report -> notionalAmountScheduleLeg2Report.getAmount()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult = false;
							}
							return MapperS.of(Schedule11__1.builder()
								.setUadjstdFctvDt(item.<Date>map("getEffectiveDate", notionalAmountScheduleLeg2Report -> notionalAmountScheduleLeg2Report.getEffectiveDate()).get())
								.setAmt(AmountAndDirection106__2.builder()
									.setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
										.setValue(abs.evaluate(item.<BigDecimal>map("getAmount", notionalAmountScheduleLeg2Report -> notionalAmountScheduleLeg2Report.getAmount()).get()))
										.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getNotionalCurrencyLeg2", aSICTransactionReport -> aSICTransactionReport.getNotionalCurrencyLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
										.build())
									.setSgn(ifThenElseResult)
									.build())
								.build());
						}).getMulti())
					.build())
				.build());
			
			return Optional.ofNullable(ntnlAmt)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
