package drr.projection.iso20022.esma.emir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.NotionalQuantityScheduleLeg1Report;
import drr.regulation.esma.emir.refit.trade.NotionalQuantityScheduleLeg2Report;
import iso20022.auth030.esma.NotionalQuantity9__2;
import iso20022.auth030.esma.NotionalQuantityLegs5__2;
import iso20022.auth030.esma.QuantityOrTerm1Choice__1;
import iso20022.auth030.esma.Schedule10__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(GetNtnlQty2.GetNtnlQty2Default.class)
public abstract class GetNtnlQty2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param drrReport 
	* @return ntnlQty 
	*/
	public NotionalQuantityLegs5__2 evaluate(ESMAEMIRTransactionReport drrReport) {
		NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder ntnlQtyBuilder = doEvaluate(drrReport);
		
		final NotionalQuantityLegs5__2 ntnlQty;
		if (ntnlQtyBuilder == null) {
			ntnlQty = null;
		} else {
			ntnlQty = ntnlQtyBuilder.build();
			objectValidator.validate(NotionalQuantityLegs5__2.class, ntnlQty);
		}
		
		return ntnlQty;
	}

	protected abstract NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder doEvaluate(ESMAEMIRTransactionReport drrReport);

	public static class GetNtnlQty2Default extends GetNtnlQty2 {
		@Override
		protected NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder doEvaluate(ESMAEMIRTransactionReport drrReport) {
			NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder ntnlQty = NotionalQuantityLegs5__2.builder();
			return assignOutput(ntnlQty, drrReport);
		}
		
		protected NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder assignOutput(NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder ntnlQty, ESMAEMIRTransactionReport drrReport) {
			ntnlQty = toBuilder(NotionalQuantityLegs5__2.builder()
				.setFrstLeg(NotionalQuantity9__2.builder()
					.setTtlQty(MapperS.of(drrReport).<BigDecimal>map("getTotalNotionalQuantityLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getTotalNotionalQuantityLeg1()).get())
					.setDtls(QuantityOrTerm1Choice__1.builder()
						.setSchdlPrd(MapperS.of(drrReport).<NotionalQuantityScheduleLeg1Report>mapC("getNotionalQuantityScheduleLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getNotionalQuantityScheduleLeg1())
							.mapItem(item -> MapperS.of(Schedule10__1.builder()
								.setUadjstdFctvDt(item.<Date>map("getEffectiveDate", notionalQuantityScheduleLeg1Report -> notionalQuantityScheduleLeg1Report.getEffectiveDate()).get())
								.setUadjstdEndDt(item.<Date>map("getEndDate", notionalQuantityScheduleLeg1Report -> notionalQuantityScheduleLeg1Report.getEndDate()).get())
								.setQty(item.<BigDecimal>map("getValue", notionalQuantityScheduleLeg1Report -> notionalQuantityScheduleLeg1Report.getValue()).get())
								.build())).getMulti())
						.build())
					.build())
				.setScndLeg(NotionalQuantity9__2.builder()
					.setTtlQty(MapperS.of(drrReport).<BigDecimal>map("getTotalNotionalQuantityLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getTotalNotionalQuantityLeg2()).get())
					.setDtls(QuantityOrTerm1Choice__1.builder()
						.setSchdlPrd(MapperS.of(drrReport).<NotionalQuantityScheduleLeg2Report>mapC("getNotionalQuantityScheduleLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getNotionalQuantityScheduleLeg2())
							.mapItem(item -> MapperS.of(Schedule10__1.builder()
								.setUadjstdFctvDt(item.<Date>map("getEffectiveDate", notionalQuantityScheduleLeg2Report -> notionalQuantityScheduleLeg2Report.getEffectiveDate()).get())
								.setUadjstdEndDt(item.<Date>map("getEndDate", notionalQuantityScheduleLeg2Report -> notionalQuantityScheduleLeg2Report.getEndDate()).get())
								.setQty(item.<BigDecimal>map("getValue", notionalQuantityScheduleLeg2Report -> notionalQuantityScheduleLeg2Report.getValue()).get())
								.build())).getMulti())
						.build())
					.build())
				.build());
			
			return Optional.ofNullable(ntnlQty)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
