package drr.projection.iso20022.esma.emir.refit.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.util.functions.StringLength;
import drr.regulation.common.util.functions.SubString;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.StrikePriceAndNotation;
import drr.regulation.esma.emir.refit.trade.StrikePriceScheduleReport;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.esma.ActiveOrHistoricCurrencyAnd13DecimalAmount__1;
import iso20022.auth030.esma.ActiveOrHistoricCurrencyAnd5DecimalAmount__1;
import iso20022.auth030.esma.AmountAndDirection106__1;
import iso20022.auth030.esma.OptionOrSwaption10__1;
import iso20022.auth030.esma.OptionStyle6Code__1;
import iso20022.auth030.esma.OptionType2Code;
import iso20022.auth030.esma.Schedule4__1;
import iso20022.auth030.esma.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetOptn.GetOptnDefault.class)
public abstract class GetOptn implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Abs abs;
	@Inject protected StringLength stringLength;
	@Inject protected SubString subString;

	/**
	* @param drrReport 
	* @return optn 
	*/
	public OptionOrSwaption10__1 evaluate(ESMAEMIRTransactionReport drrReport) {
		OptionOrSwaption10__1.OptionOrSwaption10__1Builder optnBuilder = doEvaluate(drrReport);
		
		final OptionOrSwaption10__1 optn;
		if (optnBuilder == null) {
			optn = null;
		} else {
			optn = optnBuilder.build();
			objectValidator.validate(OptionOrSwaption10__1.class, optn);
		}
		
		return optn;
	}

	protected abstract OptionOrSwaption10__1.OptionOrSwaption10__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport);

	public static class GetOptnDefault extends GetOptn {
		@Override
		protected OptionOrSwaption10__1.OptionOrSwaption10__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport) {
			OptionOrSwaption10__1.OptionOrSwaption10__1Builder optn = OptionOrSwaption10__1.builder();
			return assignOutput(optn, drrReport);
		}
		
		protected OptionOrSwaption10__1.OptionOrSwaption10__1Builder assignOutput(OptionOrSwaption10__1.OptionOrSwaption10__1Builder optn, ESMAEMIRTransactionReport drrReport) {
			optn = toBuilder(OptionOrSwaption10__1.builder()
				.setTp(MapperS.of(drrReport).<String>map("getOptionType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionType()).checkedMap("to-enum", OptionType2Code::fromDisplayName, IllegalArgumentException.class).get())
				.setExrcStyle(MapperS.of(drrReport).<String>map("getOptionStyle", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionStyle()).checkedMap("to-enum", OptionStyle6Code__1::fromDisplayName, IllegalArgumentException.class).get())
				.setStrkPric(MapperS.of(drrReport).<StrikePriceAndNotation>map("getStrikePrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePrice())
					.mapSingleToItem(item -> {
						AmountAndDirection106__1 ifThenElseResult2 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							String ifThenElseResult0 = null;
							if (areEqual(MapperS.of(drrReport).<String>map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), MapperS.of("OPTN"), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(drrReport).<String>map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), MapperS.of("SWPT"), CardinalityOperator.All)).andNullSafe(exists(MapperS.of(drrReport).<String>map("getAssetClass", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getAssetClass())).andNullSafe(notEqual(MapperS.of(drrReport).<String>map("getAssetClass", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getAssetClass()), MapperS.of("INTR"), CardinalityOperator.Any))).getOrDefault(false)) {
								if (greaterThan(MapperS.of(stringLength.evaluate(item.<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get())), MapperS.of(3), CardinalityOperator.All).getOrDefault(false)) {
									ifThenElseResult0 = subString.evaluate(item.<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get(), 5, 3);
								} else {
									ifThenElseResult0 = item.<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get();
								}
							}
							Boolean ifThenElseResult1 = null;
							if (lessThan(item.<BigDecimal>map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult1 = false;
							}
							ifThenElseResult2 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder()
									.setValue(abs.evaluate(item.<BigDecimal>map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary()).get()))
									.setCcy(ifThenElseResult0)
									.build())
								.setSgn(ifThenElseResult1)
								.build();
						}
						BigDecimal ifThenElseResult3 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult3 = item.<BigDecimal>map("getStrikePricePercentage", strikePriceAndNotation -> strikePriceAndNotation.getStrikePricePercentage()).get();
						}
						return MapperS.of(SecuritiesTransactionPrice17Choice__1.builder()
							.setMntryVal(ifThenElseResult2)
							.setPctg(ifThenElseResult3)
							.build());
					}).get())
				.setStrkPricSchdl(MapperS.of(drrReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePriceSchedule())
					.mapItem(item -> {
						AmountAndDirection106__1 ifThenElseResult2 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotationInEffectOnAssociatedEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							String ifThenElseResult0 = null;
							if (areEqual(MapperS.of(drrReport).<String>map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), MapperS.of("OPTN"), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(drrReport).<String>map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), MapperS.of("SWPT"), CardinalityOperator.All)).andNullSafe(areEqual(areEqual(MapperS.of(drrReport).<String>map("getAssetClass", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getAssetClass()), MapperS.of("INTR"), CardinalityOperator.All), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
								if (greaterThan(MapperS.of(stringLength.evaluate(MapperS.of(drrReport).<StrikePriceAndNotation>map("getStrikePrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePrice()).<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).map("to-string", Object::toString).get())), MapperS.of(3), CardinalityOperator.All).getOrDefault(false)) {
									ifThenElseResult0 = subString.evaluate(MapperS.of(drrReport).<StrikePriceAndNotation>map("getStrikePrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePrice()).<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).map("to-string", Object::toString).get(), 5, 3);
								} else {
									ifThenElseResult0 = MapperS.of(drrReport).<StrikePriceAndNotation>map("getStrikePrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePrice()).<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).map("to-string", Object::toString).get();
								}
							}
							Boolean ifThenElseResult1 = null;
							if (lessThan(item.<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult1 = false;
							}
							ifThenElseResult2 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder()
									.setValue(abs.evaluate(item.<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()).get()))
									.setCcy(ifThenElseResult0)
									.build())
								.setSgn(ifThenElseResult1)
								.build();
						}
						BigDecimal ifThenElseResult3 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotationInEffectOnAssociatedEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult3 = item.<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDatePercentage", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDatePercentage()).get();
						}
						return MapperS.of(Schedule4__1.builder()
							.setUadjstdFctvDt(item.<Date>map("getEffectiveDateStrikePrice", strikePriceScheduleReport -> strikePriceScheduleReport.getEffectiveDateStrikePrice()).get())
							.setUadjstdEndDt(item.<Date>map("getEndDateStrikePrice", strikePriceScheduleReport -> strikePriceScheduleReport.getEndDateStrikePrice()).get())
							.setPric(SecuritiesTransactionPrice17Choice__1.builder()
								.setMntryVal(ifThenElseResult2)
								.setPctg(ifThenElseResult3)
								.build())
							.build());
					}).getMulti())
				.setPrmAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount__1.builder()
					.setValue(MapperS.of(drrReport).<BigDecimal>map("getOptionPremiumAmount", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionPremiumAmount()).get())
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getOptionPremiumCurrency", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setPrmPmtDt(MapperS.of(drrReport).<Date>map("getOptionPremiumPaymentDate", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionPremiumPaymentDate()).get())
				.setMtrtyDtOfUndrlyg(MapperS.of(drrReport).<Date>map("getMaturityDateOfTheUnderlying", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getMaturityDateOfTheUnderlying()).get())
				.build());
			
			return Optional.ofNullable(optn)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
