package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg1;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.jfsa.FloatingRate13__1;
import iso20022.auth030.jfsa.InterestComputationMethod4Code;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Create_FloatingRateLeg1.Create_FloatingRateLeg1Default.class)
public abstract class Create_FloatingRateLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_FloatingRate13__1 create_FloatingRate13__1;

	/**
	* @param drrReport 
	* @return fltg 
	*/
	public FloatingRate13__1 evaluate(JFSATransactionReport drrReport) {
		FloatingRate13__1.FloatingRate13__1Builder fltgBuilder = doEvaluate(drrReport);
		
		final FloatingRate13__1 fltg;
		if (fltgBuilder == null) {
			fltg = null;
		} else {
			fltg = fltgBuilder.build();
			objectValidator.validate(FloatingRate13__1.class, fltg);
		}
		
		return fltg;
	}

	protected abstract FloatingRate13__1.FloatingRate13__1Builder doEvaluate(JFSATransactionReport drrReport);

	public static class Create_FloatingRateLeg1Default extends Create_FloatingRateLeg1 {
		@Override
		protected FloatingRate13__1.FloatingRate13__1Builder doEvaluate(JFSATransactionReport drrReport) {
			FloatingRate13__1.FloatingRate13__1Builder fltg = FloatingRate13__1.builder();
			return assignOutput(fltg, drrReport);
		}
		
		protected FloatingRate13__1.FloatingRate13__1Builder assignOutput(FloatingRate13__1.FloatingRate13__1Builder fltg, JFSATransactionReport drrReport) {
			fltg = toBuilder(create_FloatingRate13__1.evaluate(MapperS.of(drrReport).<String>map("getNameOfTheFloatingRateOfLeg1", jFSATransactionReport -> jFSATransactionReport.getNameOfTheFloatingRateOfLeg1()).get(), MapperS.of(drrReport).<String>map("getIndicatorOfTheFloatingRateOfLeg1", jFSATransactionReport -> jFSATransactionReport.getIndicatorOfTheFloatingRateOfLeg1()).get(), MapperS.of(drrReport).<String>map("getFloatingRateReferencePeriodOfLeg1TimePeriod", jFSATransactionReport -> jFSATransactionReport.getFloatingRateReferencePeriodOfLeg1TimePeriod()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateReferencePeriodOfLeg1Multiplier", jFSATransactionReport -> jFSATransactionReport.getFloatingRateReferencePeriodOfLeg1Multiplier()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", jFSATransactionReport -> jFSATransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Monetary", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Monetary()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", jFSATransactionReport -> jFSATransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Decimal", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Decimal()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", jFSATransactionReport -> jFSATransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Basis", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Basis()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", jFSATransactionReport -> jFSATransactionReport.getSpreadOfLeg1()).<ISOCurrencyCodeEnum>map("getSpreadCurrencyOfLeg1", spreadOfLeg1 -> spreadOfLeg1.getSpreadCurrencyOfLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", jFSATransactionReport -> jFSATransactionReport.getSpreadOfLeg1()).<PriceNotationEnum>map("getSpreadOfLeg1Notation", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Notation()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionOfLeg1", jFSATransactionReport -> jFSATransactionReport.getFloatingRateDayCountConventionOfLeg1()).map("to-string", InterestComputationMethod4Code::toDisplayString).get(), MapperS.of(drrReport).<String>map("getFloatingRatePaymentFrequencyPeriodLeg1", jFSATransactionReport -> jFSATransactionReport.getFloatingRatePaymentFrequencyPeriodLeg1()).map("to-string", Object::toString).get(), MapperS.of(drrReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierLeg1", jFSATransactionReport -> jFSATransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1()).get(), MapperS.of(drrReport).<String>map("getFloatingRateResetFrequencyPeriodLeg1", jFSATransactionReport -> jFSATransactionReport.getFloatingRateResetFrequencyPeriodLeg1()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierLeg1", jFSATransactionReport -> jFSATransactionReport.getFloatingRateResetFrequencyPeriodMultiplierLeg1()).get()));
			
			return Optional.ofNullable(fltg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
