package drr.projection.iso20022.mas.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg1;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.mas.Frequency13Code__1;
import iso20022.auth030.mas.InterestComputationMethod4Code;
import iso20022.auth030.mas.InterestRate33Choice__1;
import iso20022.auth030.mas.InterestRateLegs14__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(GetIntrstRate.GetIntrstRateDefault.class)
public abstract class GetIntrstRate implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_FixedRate create_FixedRate;
	@Inject protected Create_FloatingRate create_FloatingRate;

	/**
	* @param drrReport 
	* @return intrstRate 
	*/
	public InterestRateLegs14__1 evaluate(MASTransactionReport drrReport) {
		InterestRateLegs14__1.InterestRateLegs14__1Builder intrstRateBuilder = doEvaluate(drrReport);
		
		final InterestRateLegs14__1 intrstRate;
		if (intrstRateBuilder == null) {
			intrstRate = null;
		} else {
			intrstRate = intrstRateBuilder.build();
			objectValidator.validate(InterestRateLegs14__1.class, intrstRate);
		}
		
		return intrstRate;
	}

	protected abstract InterestRateLegs14__1.InterestRateLegs14__1Builder doEvaluate(MASTransactionReport drrReport);

	public static class GetIntrstRateDefault extends GetIntrstRate {
		@Override
		protected InterestRateLegs14__1.InterestRateLegs14__1Builder doEvaluate(MASTransactionReport drrReport) {
			InterestRateLegs14__1.InterestRateLegs14__1Builder intrstRate = InterestRateLegs14__1.builder();
			return assignOutput(intrstRate, drrReport);
		}
		
		protected InterestRateLegs14__1.InterestRateLegs14__1Builder assignOutput(InterestRateLegs14__1.InterestRateLegs14__1Builder intrstRate, MASTransactionReport drrReport) {
			intrstRate = toBuilder(InterestRateLegs14__1.builder()
				.setFrstLeg(InterestRate33Choice__1.builder()
					.setFxd(create_FixedRate.evaluate(MapperS.of(drrReport).<BigDecimal>map("getFixedRateOfLeg1", mASTransactionReport -> mASTransactionReport.getFixedRateOfLeg1()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionOfLeg1", mASTransactionReport -> mASTransactionReport.getFixedRateDayCountConventionOfLeg1()).get(), MapperS.of(drrReport).<Frequency13Code__1>map("getFixedRatePaymentFrequencyPeriodOfLeg1", mASTransactionReport -> mASTransactionReport.getFixedRatePaymentFrequencyPeriodOfLeg1()).get(), MapperS.of(drrReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1", mASTransactionReport -> mASTransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1()).get()))
					.setFltg(create_FloatingRate.evaluate(MapperS.of(drrReport).<String>map("getIdentifierOfFloatingRateOfLeg1", mASTransactionReport -> mASTransactionReport.getIdentifierOfFloatingRateOfLeg1()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", mASTransactionReport -> mASTransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Monetary", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Monetary()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", mASTransactionReport -> mASTransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Decimal", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Decimal()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", mASTransactionReport -> mASTransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Basis", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Basis()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", mASTransactionReport -> mASTransactionReport.getSpreadOfLeg1()).<ISOCurrencyCodeEnum>map("getSpreadCurrencyOfLeg1", spreadOfLeg1 -> spreadOfLeg1.getSpreadCurrencyOfLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", mASTransactionReport -> mASTransactionReport.getSpreadOfLeg1()).<PriceNotationEnum>map("getSpreadNotationOfLeg1", spreadOfLeg1 -> spreadOfLeg1.getSpreadNotationOfLeg1()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionOfLeg1", mASTransactionReport -> mASTransactionReport.getFloatingRateDayCountConventionOfLeg1()).get(), MapperS.of(drrReport).<Frequency13Code__1>map("getFloatingRatePaymentFrequencyPeriodOfLeg1", mASTransactionReport -> mASTransactionReport.getFloatingRatePaymentFrequencyPeriodOfLeg1()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1", mASTransactionReport -> mASTransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()).get(), MapperS.of(drrReport).<String>map("getNameOfTheFloatingRateOfLeg1", mASTransactionReport -> mASTransactionReport.getNameOfTheFloatingRateOfLeg1()).get(), MapperS.of(drrReport).<String>map("getFloatingRateResetFrequencyPeriodOfLeg1", mASTransactionReport -> mASTransactionReport.getFloatingRateResetFrequencyPeriodOfLeg1()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierOfLeg1", mASTransactionReport -> mASTransactionReport.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1()).get()))
					.build())
				.setScndLeg(InterestRate33Choice__1.builder()
					.setFxd(create_FixedRate.evaluate(MapperS.of(drrReport).<BigDecimal>map("getFixedRateOfLeg2", mASTransactionReport -> mASTransactionReport.getFixedRateOfLeg2()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionOfLeg2", mASTransactionReport -> mASTransactionReport.getFixedRateDayCountConventionOfLeg2()).get(), MapperS.of(drrReport).<Frequency13Code__1>map("getFixedRatePaymentFrequencyPeriodOfLeg2", mASTransactionReport -> mASTransactionReport.getFixedRatePaymentFrequencyPeriodOfLeg2()).get(), MapperS.of(drrReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2", mASTransactionReport -> mASTransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2()).get()))
					.setFltg(create_FloatingRate.evaluate(MapperS.of(drrReport).<String>map("getIdentifierOfFloatingRateOfLeg2", mASTransactionReport -> mASTransactionReport.getIdentifierOfFloatingRateOfLeg2()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", mASTransactionReport -> mASTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Monetary", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Monetary()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", mASTransactionReport -> mASTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Decimal", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Decimal()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", mASTransactionReport -> mASTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Basis", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Basis()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", mASTransactionReport -> mASTransactionReport.getSpreadOfLeg2()).<ISOCurrencyCodeEnum>map("getSpreadCurrencyOfLeg2", spreadOfLeg2 -> spreadOfLeg2.getSpreadCurrencyOfLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", mASTransactionReport -> mASTransactionReport.getSpreadOfLeg2()).<PriceNotationEnum>map("getSpreadNotationOfLeg2", spreadOfLeg2 -> spreadOfLeg2.getSpreadNotationOfLeg2()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionOfLeg2", mASTransactionReport -> mASTransactionReport.getFloatingRateDayCountConventionOfLeg2()).get(), MapperS.of(drrReport).<Frequency13Code__1>map("getFloatingRatePaymentFrequencyPeriodOfLeg2", mASTransactionReport -> mASTransactionReport.getFloatingRatePaymentFrequencyPeriodOfLeg2()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2", mASTransactionReport -> mASTransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()).get(), MapperS.of(drrReport).<String>map("getNameOfTheFloatingRateOfLeg2", mASTransactionReport -> mASTransactionReport.getNameOfTheFloatingRateOfLeg2()).get(), MapperS.of(drrReport).<String>map("getFloatingRateResetFrequencyPeriodOfLeg2", mASTransactionReport -> mASTransactionReport.getFloatingRateResetFrequencyPeriodOfLeg2()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierOfLeg2", mASTransactionReport -> mASTransactionReport.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2()).get()))
					.build())
				.build());
			
			return Optional.ofNullable(intrstRate)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
