package drr.regulation.asic.rewrite.trade;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.asic.rewrite.trade.meta.BasketConstituentsReportMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.58.0
 */
@RosettaDataType(value="BasketConstituentsReport", builder=BasketConstituentsReport.BasketConstituentsReportBuilderImpl.class, version="5.58.0")
@RuneDataType(value="BasketConstituentsReport", model="drr", builder=BasketConstituentsReport.BasketConstituentsReportBuilderImpl.class, version="5.58.0")
public interface BasketConstituentsReport extends RosettaModelObject {

	BasketConstituentsReportMeta metaData = new BasketConstituentsReportMeta();

	/*********************** Getter Methods  ***********************/
	String getIdentifier();
	ProductIdTypeEnum getSource();

	/*********************** Build Methods  ***********************/
	BasketConstituentsReport build();
	
	BasketConstituentsReport.BasketConstituentsReportBuilder toBuilder();
	
	static BasketConstituentsReport.BasketConstituentsReportBuilder builder() {
		return new BasketConstituentsReport.BasketConstituentsReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends BasketConstituentsReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends BasketConstituentsReport> getType() {
		return BasketConstituentsReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("identifier"), String.class, getIdentifier(), this);
		processor.processBasic(path.newSubPath("source"), ProductIdTypeEnum.class, getSource(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface BasketConstituentsReportBuilder extends BasketConstituentsReport, RosettaModelObjectBuilder {
		BasketConstituentsReport.BasketConstituentsReportBuilder setIdentifier(String identifier);
		BasketConstituentsReport.BasketConstituentsReportBuilder setSource(ProductIdTypeEnum source);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("identifier"), String.class, getIdentifier(), this);
			processor.processBasic(path.newSubPath("source"), ProductIdTypeEnum.class, getSource(), this);
		}
		

		BasketConstituentsReport.BasketConstituentsReportBuilder prune();
	}

	/*********************** Immutable Implementation of BasketConstituentsReport  ***********************/
	class BasketConstituentsReportImpl implements BasketConstituentsReport {
		private final String identifier;
		private final ProductIdTypeEnum source;
		
		protected BasketConstituentsReportImpl(BasketConstituentsReport.BasketConstituentsReportBuilder builder) {
			this.identifier = builder.getIdentifier();
			this.source = builder.getSource();
		}
		
		@Override
		@RosettaAttribute("identifier")
		@RuneAttribute("identifier")
		public String getIdentifier() {
			return identifier;
		}
		
		@Override
		@RosettaAttribute("source")
		@RuneAttribute("source")
		public ProductIdTypeEnum getSource() {
			return source;
		}
		
		@Override
		public BasketConstituentsReport build() {
			return this;
		}
		
		@Override
		public BasketConstituentsReport.BasketConstituentsReportBuilder toBuilder() {
			BasketConstituentsReport.BasketConstituentsReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(BasketConstituentsReport.BasketConstituentsReportBuilder builder) {
			ofNullable(getIdentifier()).ifPresent(builder::setIdentifier);
			ofNullable(getSource()).ifPresent(builder::setSource);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			BasketConstituentsReport _that = getType().cast(o);
		
			if (!Objects.equals(identifier, _that.getIdentifier())) return false;
			if (!Objects.equals(source, _that.getSource())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (identifier != null ? identifier.hashCode() : 0);
			_result = 31 * _result + (source != null ? source.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "BasketConstituentsReport {" +
				"identifier=" + this.identifier + ", " +
				"source=" + this.source +
			'}';
		}
	}

	/*********************** Builder Implementation of BasketConstituentsReport  ***********************/
	class BasketConstituentsReportBuilderImpl implements BasketConstituentsReport.BasketConstituentsReportBuilder {
	
		protected String identifier;
		protected ProductIdTypeEnum source;
		
		@Override
		@RosettaAttribute("identifier")
		@RuneAttribute("identifier")
		public String getIdentifier() {
			return identifier;
		}
		
		@Override
		@RosettaAttribute("source")
		@RuneAttribute("source")
		public ProductIdTypeEnum getSource() {
			return source;
		}
		
		@RosettaAttribute("identifier")
		@RuneAttribute("identifier")
		@Override
		public BasketConstituentsReport.BasketConstituentsReportBuilder setIdentifier(String _identifier) {
			this.identifier = _identifier == null ? null : _identifier;
			return this;
		}
		
		@RosettaAttribute("source")
		@RuneAttribute("source")
		@Override
		public BasketConstituentsReport.BasketConstituentsReportBuilder setSource(ProductIdTypeEnum _source) {
			this.source = _source == null ? null : _source;
			return this;
		}
		
		@Override
		public BasketConstituentsReport build() {
			return new BasketConstituentsReport.BasketConstituentsReportImpl(this);
		}
		
		@Override
		public BasketConstituentsReport.BasketConstituentsReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public BasketConstituentsReport.BasketConstituentsReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getIdentifier()!=null) return true;
			if (getSource()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public BasketConstituentsReport.BasketConstituentsReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			BasketConstituentsReport.BasketConstituentsReportBuilder o = (BasketConstituentsReport.BasketConstituentsReportBuilder) other;
			
			
			merger.mergeBasic(getIdentifier(), o.getIdentifier(), this::setIdentifier);
			merger.mergeBasic(getSource(), o.getSource(), this::setSource);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			BasketConstituentsReport _that = getType().cast(o);
		
			if (!Objects.equals(identifier, _that.getIdentifier())) return false;
			if (!Objects.equals(source, _that.getSource())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (identifier != null ? identifier.hashCode() : 0);
			_result = 31 * _result + (source != null ? source.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "BasketConstituentsReportBuilder {" +
				"identifier=" + this.identifier + ", " +
				"source=" + this.source +
			'}';
		}
	}
}
