package drr.regulation.asic.rewrite.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.asic.rewrite.trade.meta.NotionalAmountScheduleLeg1ReportMeta;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.58.0
 */
@RosettaDataType(value="NotionalAmountScheduleLeg1Report", builder=NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilderImpl.class, version="5.58.0")
@RuneDataType(value="NotionalAmountScheduleLeg1Report", model="drr", builder=NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilderImpl.class, version="5.58.0")
public interface NotionalAmountScheduleLeg1Report extends RosettaModelObject {

	NotionalAmountScheduleLeg1ReportMeta metaData = new NotionalAmountScheduleLeg1ReportMeta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getAmount();
	Date getEffectiveDate();

	/*********************** Build Methods  ***********************/
	NotionalAmountScheduleLeg1Report build();
	
	NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder toBuilder();
	
	static NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder builder() {
		return new NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends NotionalAmountScheduleLeg1Report> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends NotionalAmountScheduleLeg1Report> getType() {
		return NotionalAmountScheduleLeg1Report.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("amount"), BigDecimal.class, getAmount(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface NotionalAmountScheduleLeg1ReportBuilder extends NotionalAmountScheduleLeg1Report, RosettaModelObjectBuilder {
		NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder setAmount(BigDecimal amount);
		NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder setEffectiveDate(Date effectiveDate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("amount"), BigDecimal.class, getAmount(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		}
		

		NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder prune();
	}

	/*********************** Immutable Implementation of NotionalAmountScheduleLeg1Report  ***********************/
	class NotionalAmountScheduleLeg1ReportImpl implements NotionalAmountScheduleLeg1Report {
		private final BigDecimal amount;
		private final Date effectiveDate;
		
		protected NotionalAmountScheduleLeg1ReportImpl(NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder builder) {
			this.amount = builder.getAmount();
			this.effectiveDate = builder.getEffectiveDate();
		}
		
		@Override
		@RosettaAttribute("amount")
		@RuneAttribute("amount")
		public BigDecimal getAmount() {
			return amount;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		public NotionalAmountScheduleLeg1Report build() {
			return this;
		}
		
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder toBuilder() {
			NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder builder) {
			ofNullable(getAmount()).ifPresent(builder::setAmount);
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			NotionalAmountScheduleLeg1Report _that = getType().cast(o);
		
			if (!Objects.equals(amount, _that.getAmount())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amount != null ? amount.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "NotionalAmountScheduleLeg1Report {" +
				"amount=" + this.amount + ", " +
				"effectiveDate=" + this.effectiveDate +
			'}';
		}
	}

	/*********************** Builder Implementation of NotionalAmountScheduleLeg1Report  ***********************/
	class NotionalAmountScheduleLeg1ReportBuilderImpl implements NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder {
	
		protected BigDecimal amount;
		protected Date effectiveDate;
		
		@Override
		@RosettaAttribute("amount")
		@RuneAttribute("amount")
		public BigDecimal getAmount() {
			return amount;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@RosettaAttribute("amount")
		@RuneAttribute("amount")
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder setAmount(BigDecimal _amount) {
			this.amount = _amount == null ? null : _amount;
			return this;
		}
		
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@Override
		public NotionalAmountScheduleLeg1Report build() {
			return new NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportImpl(this);
		}
		
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getAmount()!=null) return true;
			if (getEffectiveDate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder o = (NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder) other;
			
			
			merger.mergeBasic(getAmount(), o.getAmount(), this::setAmount);
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			NotionalAmountScheduleLeg1Report _that = getType().cast(o);
		
			if (!Objects.equals(amount, _that.getAmount())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amount != null ? amount.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "NotionalAmountScheduleLeg1ReportBuilder {" +
				"amount=" + this.amount + ", " +
				"effectiveDate=" + this.effectiveDate +
			'}';
		}
	}
}
