package drr.regulation.asic.rewrite.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import drr.regulation.asic.rewrite.trade.validation.SpreadLeg1TypeFormatValidator;
import drr.regulation.asic.rewrite.trade.validation.SpreadLeg1Validator;
import drr.regulation.asic.rewrite.trade.validation.datarule.SpreadLeg1MonetaryOrDecimalOrBasis;
import drr.regulation.asic.rewrite.trade.validation.exists.SpreadLeg1OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.58.0
 */
@RosettaMeta(model=SpreadLeg1.class)
public class SpreadLeg1Meta implements RosettaMetaData<SpreadLeg1> {

	@Override
	public List<Validator<? super SpreadLeg1>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<SpreadLeg1>create(SpreadLeg1MonetaryOrDecimalOrBasis.class)
		);
	}
	
	@Override
	public List<Function<? super SpreadLeg1, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super SpreadLeg1> validator(ValidatorFactory factory) {
		return factory.<SpreadLeg1>create(SpreadLeg1Validator.class);
	}

	@Override
	public Validator<? super SpreadLeg1> typeFormatValidator(ValidatorFactory factory) {
		return factory.<SpreadLeg1>create(SpreadLeg1TypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super SpreadLeg1> validator() {
		return new SpreadLeg1Validator();
	}

	@Deprecated
	@Override
	public Validator<? super SpreadLeg1> typeFormatValidator() {
		return new SpreadLeg1TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super SpreadLeg1, Set<String>> onlyExistsValidator() {
		return new SpreadLeg1OnlyExistsValidator();
	}
}
