package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.reports.CDESpreadLeg2NotationEnumRule;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetSpreadLeg2NotationEnumRule.GetSpreadLeg2NotationEnumRuleDefault.class)
public abstract class GetSpreadLeg2NotationEnumRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpreadLeg2NotationEnumRule cDESpreadLeg2NotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class GetSpreadLeg2NotationEnumRuleDefault extends GetSpreadLeg2NotationEnumRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			if (areEqual(MapperS.of(cDESpreadLeg2NotationEnumRule.evaluate(input)), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
				output = PriceNotationEnum.DECIMAL;
			} else {
				output = cDESpreadLeg2NotationEnumRule.evaluate(input);
			}
			
			return output;
		}
	}
}
