package drr.regulation.asic.rewrite.trade.reports;

import cdm.observable.event.Trigger;
import cdm.observable.event.TriggerEvent;
import cdm.product.template.Knock;
import cdm.product.template.OptionFeature;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.ProductForEvent;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(LowerBarrierPriceDecimalRule.LowerBarrierPriceDecimalRuleDefault.class)
public abstract class LowerBarrierPriceDecimalRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FormatToBaseOneRate formatToBaseOneRate;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected IsOption isOption;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class LowerBarrierPriceDecimalRuleDefault extends LowerBarrierPriceDecimalRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperC<OptionFeature> thenArg1 = thenArg0
				.mapSingleToList(item -> {
					if (ComparisonResult.ofNullSafe(MapperS.of(isOption.evaluate(productForEvent.evaluate(item.get())))).andNullSafe(exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockIn", knock -> knock.getKnockIn()))).andNullSafe(exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockOut", knock -> knock.getKnockOut()))).getOrDefault(false)) {
						return MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature());
					}
					return MapperC.<OptionFeature>ofNull();
				});
			final MapperC<BigDecimal> ifThenElseResult;
			if (exists(thenArg1.<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevelPercentage", trigger -> trigger.getLevelPercentage())).getOrDefault(false)) {
				ifThenElseResult = thenArg1.<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevelPercentage", trigger -> trigger.getLevelPercentage());
			} else if (exists(thenArg1.<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockOut", knock -> knock.getKnockOut()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevelPercentage", trigger -> trigger.getLevelPercentage())).getOrDefault(false)) {
				ifThenElseResult = thenArg1.<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockOut", knock -> knock.getKnockOut()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevelPercentage", trigger -> trigger.getLevelPercentage());
			} else {
				ifThenElseResult = MapperC.<BigDecimal>ofNull();
			}
			final MapperS<BigDecimal> thenArg2 = ifThenElseResult
				.min();
			output = MapperS.of(formatToBaseOneRate.evaluate(thenArg2.get())).get();
			
			return output;
		}
	}
}
