package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import cdm.base.staticdata.party.PartyReferencePayerReceiver;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Transfer;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PartyIdentifierFormatEnum;
import drr.regulation.common.functions.IsOtherPayment;
import drr.standards.iosco.cde.reports.CDEOtherPaymentReceiverFormatRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(OtherPaymentReceiverFormatRule.OtherPaymentReceiverFormatRuleDefault.class)
public abstract class OtherPaymentReceiverFormatRule implements ReportFunction<TransferState, PartyIdentifierFormatEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOtherPaymentReceiverFormatRule cDEOtherPaymentReceiverFormatRule;
	@Inject protected IsOtherPayment isOtherPayment;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PartyIdentifierFormatEnum evaluate(TransferState input) {
		PartyIdentifierFormatEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PartyIdentifierFormatEnum doEvaluate(TransferState input);

	public static class OtherPaymentReceiverFormatRuleDefault extends OtherPaymentReceiverFormatRule {
		@Override
		protected PartyIdentifierFormatEnum doEvaluate(TransferState input) {
			PartyIdentifierFormatEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PartyIdentifierFormatEnum assignOutput(PartyIdentifierFormatEnum output, TransferState input) {
			final MapperS<TransferState> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isOtherPayment.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					if (areEqual(item.<Transfer>map("getTransfer", transferState -> transferState.getTransfer()).<PartyReferencePayerReceiver>map("getPayerReceiver", transfer -> transfer.getPayerReceiver()).<ReferenceWithMetaParty>map("getReceiverPartyReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getReceiverPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()).<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).<PartyIdentifierTypeEnum>map("getIdentifierType", partyIdentifier -> partyIdentifier.getIdentifierType()), MapperS.of(PartyIdentifierTypeEnum.LEI), CardinalityOperator.Any).getOrDefault(false)) {
						return MapperS.of(cDEOtherPaymentReceiverFormatRule.evaluate(item.get()));
					}
					return MapperS.<PartyIdentifierFormatEnum>ofNull();
				}).get();
			
			return output;
		}
	}
}
