package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.asset.SpreadSchedule;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.IsPriceMonetary;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iosco.cde.reports.CDESpread_CommodityRule;
import drr.standards.iosco.cde.reports.CDESpread_InterestRateRule;
import javax.inject.Inject;


@ImplementedBy(SpreadCurrencyLeg2Rule.SpreadCurrencyLeg2RuleDefault.class)
public abstract class SpreadCurrencyLeg2Rule implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpread_CommodityRule cDESpread_CommodityRule;
	@Inject protected CDESpread_InterestRateRule cDESpread_InterestRateRule;
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected IsPriceMonetary isPriceMonetary;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input);

	public static class SpreadCurrencyLeg2RuleDefault extends SpreadCurrencyLeg2Rule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<SpreadSchedule> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					final Boolean boolean0 = isIRSwaption.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(cDESpread_InterestRateRule.evaluate(interestRateLeg2.evaluate(underlierForProduct.evaluate(item.get()))));
					}
					final Boolean boolean1 = isCommoditySwap.evaluate(item.get());
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(cDESpread_CommodityRule.evaluate(commodityLeg2.evaluate(item.get())));
					}
					return MapperS.of(cDESpread_InterestRateRule.evaluate(interestRateLeg2.evaluate(item.get())));
				});
			final MapperS<ReferenceWithMetaPriceSchedule> thenArg3 = thenArg2
				.mapSingleToItem(item -> item.<ReferenceWithMetaPriceSchedule>map("getPrice", spreadSchedule -> spreadSchedule.getPrice()));
			final MapperS<ReferenceWithMetaPriceSchedule> thenArg4 = thenArg3
				.filterSingleNullSafe(item -> {
					final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = item.get();
					return isPriceMonetary.evaluate((referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()));
				});
			final MapperS<FieldWithMetaString> thenArg5 = thenArg4
				.mapSingleToItem(item -> item.<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()));
			output = thenArg5
				.mapSingleToItem(item -> {
					final FieldWithMetaString fieldWithMetaString = item.get();
					return MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString == null ? null : fieldWithMetaString.getValue())));
				}).get();
			
			return output;
		}
	}
}
