package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.PriceAndNotation;
import drr.regulation.common.ActionTypeEnum;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1047_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1047_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1047_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1047_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and (([\"INTR\", \"CRDT\"] any = assetClass and contractType = \"CFDS\") or (\"CURR\" = assetClass and [\"CFDS\", \"FRAS\", \"FORW\", \"OPTN\", \"SWAP\", \"SWPT\", \"OTHR\"] any = contractType)) then if ((price -> priceNotation = PriceNotationEnum -> Monetary and price -> priceMonetary = 999999999999999999) or (price -> priceNotation = PriceNotationEnum -> Decimal and price -> priceDecimal = 99999999999)) then True";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1047_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).andNullSafe(areEqual(MapperC.<String>of(MapperS.of("INTR"), MapperS.of("CRDT")), MapperS.of(aSICTransactionReport).<String>map("getAssetClass", _aSICTransactionReport -> _aSICTransactionReport.getAssetClass()), CardinalityOperator.Any).andNullSafe(areEqual(MapperS.of(aSICTransactionReport).<String>map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), MapperS.of("CFDS"), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of("CURR"), MapperS.of(aSICTransactionReport).<String>map("getAssetClass", _aSICTransactionReport -> _aSICTransactionReport.getAssetClass()), CardinalityOperator.All).andNullSafe(areEqual(MapperC.<String>of(MapperS.of("CFDS"), MapperS.of("FRAS"), MapperS.of("FORW"), MapperS.of("OPTN"), MapperS.of("SWAP"), MapperS.of("SWPT"), MapperS.of("OTHR")), MapperS.of(aSICTransactionReport).<String>map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), CardinalityOperator.Any)))).getOrDefault(false)) {
					if (areEqual(MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).<PriceNotationEnum>map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).<BigDecimal>map("getPriceMonetary", priceAndNotation -> priceAndNotation.getPriceMonetary()), MapperS.of(BigDecimal.valueOf(999999999999999999l)), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).<PriceNotationEnum>map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).<BigDecimal>map("getPriceDecimal", priceAndNotation -> priceAndNotation.getPriceDecimal()), MapperS.of(BigDecimal.valueOf(99999999999l)), CardinalityOperator.All))).getOrDefault(false)) {
						return ComparisonResult.ofNullSafe(MapperS.of(true));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1047_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
