package drr.regulation.asic.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.PriceAndNotation;
import drr.regulation.common.ActionTypeEnum;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1048_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1048_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1048_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1048_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType then if price -> priceNotation = PriceNotationEnum -> Monetary and price -> priceMonetary <> 999999999999999999 and price -> priceCurrency exists then [ISOCurrencyCodeEnum -> XAG, ISOCurrencyCodeEnum -> XAU, ISOCurrencyCodeEnum -> XBA, ISOCurrencyCodeEnum -> XBB, ISOCurrencyCodeEnum -> XBC, ISOCurrencyCodeEnum -> XBD, ISOCurrencyCodeEnum -> XDR, ISOCurrencyCodeEnum -> XPD, ISOCurrencyCodeEnum -> XPT, ISOCurrencyCodeEnum -> XTS] any <> price -> priceCurrency else if price -> priceNotation = PriceNotationEnum -> Decimal then price -> priceCurrency is absent";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1048_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					if (areEqual(MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).<PriceNotationEnum>map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).andNullSafe(notEqual(MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).<BigDecimal>map("getPriceMonetary", priceAndNotation -> priceAndNotation.getPriceMonetary()), MapperS.of(BigDecimal.valueOf(999999999999999999l)), CardinalityOperator.Any)).andNullSafe(exists(MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).<ISOCurrencyCodeEnum>map("getPriceCurrency", priceAndNotation -> priceAndNotation.getPriceCurrency()))).getOrDefault(false)) {
						return notEqual(MapperC.<ISOCurrencyCodeEnum>of(MapperS.of(ISOCurrencyCodeEnum.XAG), MapperS.of(ISOCurrencyCodeEnum.XAU), MapperS.of(ISOCurrencyCodeEnum.XBA), MapperS.of(ISOCurrencyCodeEnum.XBB), MapperS.of(ISOCurrencyCodeEnum.XBC), MapperS.of(ISOCurrencyCodeEnum.XBD), MapperS.of(ISOCurrencyCodeEnum.XDR), MapperS.of(ISOCurrencyCodeEnum.XPD), MapperS.of(ISOCurrencyCodeEnum.XPT), MapperS.of(ISOCurrencyCodeEnum.XTS)), MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).<ISOCurrencyCodeEnum>map("getPriceCurrency", priceAndNotation -> priceAndNotation.getPriceCurrency()), CardinalityOperator.Any);
					}
					if (areEqual(MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).<PriceNotationEnum>map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
						return notExists(MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).<ISOCurrencyCodeEnum>map("getPriceCurrency", priceAndNotation -> priceAndNotation.getPriceCurrency()));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1048_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
