package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICNonReportable;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.StrikePriceAndNotation;
import drr.regulation.common.ActionTypeEnum;
import drr.standards.iso.PriceNotationEnum;
import drr.standards.iso.upi.AnnaDsbDerived;
import drr.standards.iso.upi.AnnaDsbUpiRecord;
import drr.standards.iso.upi.AnnaDsbValuationMethodorTriggerEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1060_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1060_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1060_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1060_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and [\"OPTN\", \"SWPT\"] any = contractType then (if strikePrice -> strikePriceNotation = PriceNotationEnum -> Monetary and (nonReportable -> postUpiData -> Derived -> ValuationMethodorTrigger <> AnnaDsbValuationMethodorTriggerEnum -> Barrier or nonReportable -> postUpiData -> Derived -> ValuationMethodorTrigger <> AnnaDsbValuationMethodorTriggerEnum -> Digital_Barrier) then strikePrice -> strikePriceCurrency exists and (if [\"XAG\", \"XAU\", \"XBA\", \"XBB\", \"XBC\", \"XBD\", \"XDR\", \"XEU\", \"XFU\", \"XPD\", \"XPT\", \"XTS\"] any = strikePrice -> strikePriceCurrency then False else True) else True)";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1060_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).andNullSafe(areEqual(MapperC.<String>of(MapperS.of("OPTN"), MapperS.of("SWPT")), MapperS.of(aSICTransactionReport).<String>map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), CardinalityOperator.Any)).getOrDefault(false)) {
					if (areEqual(MapperS.of(aSICTransactionReport).<StrikePriceAndNotation>map("getStrikePrice", _aSICTransactionReport -> _aSICTransactionReport.getStrikePrice()).<PriceNotationEnum>map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).andNullSafe(notEqual(MapperS.of(aSICTransactionReport).<ASICNonReportable>map("getNonReportable", _aSICTransactionReport -> _aSICTransactionReport.getNonReportable()).<AnnaDsbUpiRecord>map("getPostUpiData", aSICNonReportable -> aSICNonReportable.getPostUpiData()).<AnnaDsbDerived>map("getDerived", annaDsbUpiRecord -> annaDsbUpiRecord.getDerived()).<AnnaDsbValuationMethodorTriggerEnum>map("getValuationMethodorTrigger", annaDsbDerived -> annaDsbDerived.getValuationMethodorTrigger()), MapperS.of(AnnaDsbValuationMethodorTriggerEnum.BARRIER), CardinalityOperator.Any).orNullSafe(notEqual(MapperS.of(aSICTransactionReport).<ASICNonReportable>map("getNonReportable", _aSICTransactionReport -> _aSICTransactionReport.getNonReportable()).<AnnaDsbUpiRecord>map("getPostUpiData", aSICNonReportable -> aSICNonReportable.getPostUpiData()).<AnnaDsbDerived>map("getDerived", annaDsbUpiRecord -> annaDsbUpiRecord.getDerived()).<AnnaDsbValuationMethodorTriggerEnum>map("getValuationMethodorTrigger", annaDsbDerived -> annaDsbDerived.getValuationMethodorTrigger()), MapperS.of(AnnaDsbValuationMethodorTriggerEnum.DIGITAL_BARRIER), CardinalityOperator.Any))).getOrDefault(false)) {
						final ComparisonResult ifThenElseResult;
						if (areEqual(MapperC.<String>of(MapperS.of("XAG"), MapperS.of("XAU"), MapperS.of("XBA"), MapperS.of("XBB"), MapperS.of("XBC"), MapperS.of("XBD"), MapperS.of("XDR"), MapperS.of("XEU"), MapperS.of("XFU"), MapperS.of("XPD"), MapperS.of("XPT"), MapperS.of("XTS")), MapperS.of(aSICTransactionReport).<StrikePriceAndNotation>map("getStrikePrice", _aSICTransactionReport -> _aSICTransactionReport.getStrikePrice()).<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()), CardinalityOperator.Any).getOrDefault(false)) {
							ifThenElseResult = ComparisonResult.ofNullSafe(MapperS.of(false));
						} else {
							ifThenElseResult = ComparisonResult.ofNullSafe(MapperS.of(true));
						}
						return exists(MapperS.of(aSICTransactionReport).<StrikePriceAndNotation>map("getStrikePrice", _aSICTransactionReport -> _aSICTransactionReport.getStrikePrice()).<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency())).andNullSafe(ifThenElseResult);
					}
					return ComparisonResult.ofNullSafe(MapperS.of(true));
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1060_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
