package drr.regulation.asic.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.PackageTransactionSpread;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("PackageTransactionSpreadMonetaryCurrency")
@ImplementedBy(PackageTransactionSpreadMonetaryCurrency.Default.class)
public interface PackageTransactionSpreadMonetaryCurrency extends Validator<PackageTransactionSpread> {
	
	String NAME = "PackageTransactionSpreadMonetaryCurrency";
	String DEFINITION = "if packageTransactionSpreadMonetary exists then packageTransactionSpreadCurrency exists";
	
	class Default implements PackageTransactionSpreadMonetaryCurrency {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionSpread packageTransactionSpread) {
			ComparisonResult result = executeDataRule(packageTransactionSpread);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PackageTransactionSpread", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "PackageTransactionSpread", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(PackageTransactionSpread packageTransactionSpread) {
			try {
				if (exists(MapperS.of(packageTransactionSpread).<BigDecimal>map("getPackageTransactionSpreadMonetary", _packageTransactionSpread -> _packageTransactionSpread.getPackageTransactionSpreadMonetary())).getOrDefault(false)) {
					return exists(MapperS.of(packageTransactionSpread).<ISOCurrencyCodeEnum>map("getPackageTransactionSpreadCurrency", _packageTransactionSpread -> _packageTransactionSpread.getPackageTransactionSpreadCurrency()));
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements PackageTransactionSpreadMonetaryCurrency {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionSpread packageTransactionSpread) {
			return Collections.emptyList();
		}
	}
}
