package drr.regulation.cftc.rewrite.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.ClearingSwapUSIsReport;
import drr.regulation.cftc.rewrite.validation.ClearingSwapUSIsReportTypeFormatValidator;
import drr.regulation.cftc.rewrite.validation.ClearingSwapUSIsReportValidator;
import drr.regulation.cftc.rewrite.validation.exists.ClearingSwapUSIsReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.58.0
 */
@RosettaMeta(model=ClearingSwapUSIsReport.class)
public class ClearingSwapUSIsReportMeta implements RosettaMetaData<ClearingSwapUSIsReport> {

	@Override
	public List<Validator<? super ClearingSwapUSIsReport>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super ClearingSwapUSIsReport, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ClearingSwapUSIsReport> validator(ValidatorFactory factory) {
		return factory.<ClearingSwapUSIsReport>create(ClearingSwapUSIsReportValidator.class);
	}

	@Override
	public Validator<? super ClearingSwapUSIsReport> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ClearingSwapUSIsReport>create(ClearingSwapUSIsReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ClearingSwapUSIsReport> validator() {
		return new ClearingSwapUSIsReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ClearingSwapUSIsReport> typeFormatValidator() {
		return new ClearingSwapUSIsReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ClearingSwapUSIsReport, Set<String>> onlyExistsValidator() {
		return new ClearingSwapUSIsReportOnlyExistsValidator();
	}
}
