package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ClearingExceptionReason;
import drr.regulation.common.ClearingExceptionReasonEnum;
import drr.regulation.common.functions.ClearingExceptionsAndExemptions;
import javax.inject.Inject;


@ImplementedBy(ClearingExceptionsAndExemptionsCounterparty2ExtractionRule.ClearingExceptionsAndExemptionsCounterparty2ExtractionRuleDefault.class)
public abstract class ClearingExceptionsAndExemptionsCounterparty2ExtractionRule implements ReportFunction<ClearingExceptionReason, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ClearingExceptionsAndExemptions clearingExceptionsAndExemptions;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ClearingExceptionReason input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ClearingExceptionReason input);

	public static class ClearingExceptionsAndExemptionsCounterparty2ExtractionRuleDefault extends ClearingExceptionsAndExemptionsCounterparty2ExtractionRule {
		@Override
		protected String doEvaluate(ClearingExceptionReason input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ClearingExceptionReason input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(clearingExceptionsAndExemptions.evaluate(item.<ClearingExceptionReasonEnum>map("getExceptionReason", clearingExceptionReason -> clearingExceptionReason.getExceptionReason()).get()))).get();
			
			return output;
		}
	}
}
