package drr.regulation.cftc.rewrite.reports;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.BusinessEvent;
import cdm.event.common.Instruction;
import cdm.event.common.Trade;
import cdm.event.common.TradeIdentifier;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.ClearingSwapUTIsReport;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FindLatestAssignedIdentifier;
import drr.regulation.common.functions.IntendedToClear;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsCleared;
import drr.standards.iosco.cde.reports.CDEEventTypeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ClearingSwapUTIsRule.ClearingSwapUTIsRuleDefault.class)
public abstract class ClearingSwapUTIsRule implements ReportFunction<TransactionReportInstruction, List<? extends ClearingSwapUTIsReport>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEEventTypeRule cDEEventTypeRule;
	@Inject protected ClearingSwapUTIRule clearingSwapUTIRule;
	@Inject protected FindLatestAssignedIdentifier findLatestAssignedIdentifier;
	@Inject protected IntendedToClear intendedToClear;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsCleared isCleared;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends ClearingSwapUTIsReport> evaluate(TransactionReportInstruction input) {
		List<ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends ClearingSwapUTIsReport> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(ClearingSwapUTIsReport::build).collect(Collectors.toList());
			objectValidator.validate(ClearingSwapUTIsReport.class, output);
		}
		
		return output;
	}

	protected abstract List<ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class ClearingSwapUTIsRuleDefault extends ClearingSwapUTIsRule {
		@Override
		protected List<ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder> assignOutput(List<ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<BusinessEvent> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> {
					if (ComparisonResult.ofNullSafe(MapperS.of(isCleared.evaluate(item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(intendedToClear.evaluate(item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get()))).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isActionTypeTERM.evaluate(item.get()))))).andNullSafe(areEqual(MapperS.of(cDEEventTypeRule.evaluate(item.get())), MapperS.of("CLRG"), CardinalityOperator.All)).getOrDefault(false)) {
						return item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent());
					}
					return MapperS.<BusinessEvent>ofNull();
				});
			final MapperC<AssignedIdentifier> thenArg1 = thenArg0
				.mapSingleToList(businessEvent -> {
					final MapperC<TradeIdentifier> _thenArg0 = businessEvent.<TradeState>mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradeIdentifier>mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier())
						.filterItemNullSafe(item -> notEqual(businessEvent.<Instruction>mapC("getInstruction", _businessEvent -> _businessEvent.getInstruction()).<ReferenceWithMetaTradeState>map("getBefore", instruction -> instruction.getBefore()).<TradeState>map("Type coercion", referenceWithMetaTradeState -> referenceWithMetaTradeState.getValue()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradeIdentifier>mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()), item, CardinalityOperator.All).get());
					final MapperC<TradeIdentifier> _thenArg1 = _thenArg0
						.filterItemNullSafe(item -> areEqual(item.<TradeIdentifierTypeEnum>map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), MapperS.of(TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER), CardinalityOperator.All).get());
					return _thenArg1
						.mapItem(item -> MapperS.of(findLatestAssignedIdentifier.evaluate(item.get())));
				});
			output = toBuilder(thenArg1
				.mapItem(item -> MapperS.of(ClearingSwapUTIsReport.builder()
					.setIdentifier(clearingSwapUTIRule.evaluate(item.get()))
					.build())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
