package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.reports.CDEPackageTransactionSpreadNotationEnumRule;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetPackageTransactionSpreadNotationEnumRule.GetPackageTransactionSpreadNotationEnumRuleDefault.class)
public abstract class GetPackageTransactionSpreadNotationEnumRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPackageTransactionSpreadNotationEnumRule cDEPackageTransactionSpreadNotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class GetPackageTransactionSpreadNotationEnumRuleDefault extends GetPackageTransactionSpreadNotationEnumRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			if (areEqual(MapperS.of(cDEPackageTransactionSpreadNotationEnumRule.evaluate(input)), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
				output = PriceNotationEnum.DECIMAL;
			} else {
				output = cDEPackageTransactionSpreadNotationEnumRule.evaluate(input);
			}
			
			return output;
		}
	}
}
