package drr.regulation.cftc.rewrite.reports;

import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.IsOtherPayment;
import drr.standards.iosco.cde.reports.CDEOtherPaymentReceiverRule;
import javax.inject.Inject;


@ImplementedBy(OtherPaymentReceiverRule.OtherPaymentReceiverRuleDefault.class)
public abstract class OtherPaymentReceiverRule implements ReportFunction<TransferState, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOtherPaymentReceiverRule cDEOtherPaymentReceiverRule;
	@Inject protected IsOtherPayment isOtherPayment;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransferState input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransferState input);

	public static class OtherPaymentReceiverRuleDefault extends OtherPaymentReceiverRule {
		@Override
		protected String doEvaluate(TransferState input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransferState input) {
			final MapperS<TransferState> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isOtherPayment.evaluate(item.get()));
			output = MapperS.of(cDEOtherPaymentReceiverRule.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
