package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.MultiplyPrice;
import drr.standards.iosco.cde.reports.CDEStrikePriceRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(StrikePriceRule.StrikePriceRuleDefault.class)
public abstract class StrikePriceRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceRule cDEStrikePriceRule;
	@Inject protected GetStrikePriceNotationEnumRule getStrikePriceNotationEnumRule;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class StrikePriceRuleDefault extends StrikePriceRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(multiplyPrice.evaluate(cDEStrikePriceRule.evaluate(item.get()), getStrikePriceNotationEnumRule.evaluate(item.get())))).get();
			
			return output;
		}
	}
}
