package drr.regulation.cftc.rewrite.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart43;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import iso20022.auth030.esma.InterestComputationMethod4Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class CFTCPart43TransactionReportValidator implements Validator<CFTCPart43TransactionReport> {

	private List<ComparisonResult> getComparisonResults(CFTCPart43TransactionReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("cleared", (String) o.getCleared() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2IdentifierSource", (String) o.getCounterparty2IdentifierSource() != null ? 1 : 0, 1, 1), 
				checkCardinality("submitterIdentifier", (String) o.getSubmitterIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("customBasketIndicator", (Boolean) o.getCustomBasketIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("actionType", (String) o.getActionType() != null ? 1 : 0, 1, 1), 
				checkCardinality("eventType", (String) o.getEventType() != null ? 1 : 0, 0, 1), 
				checkCardinality("amendmentIndicator", (Boolean) o.getAmendmentIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventTimestamp", (ZonedDateTime) o.getEventTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("notionalAmountLeg1", (BigDecimal) o.getNotionalAmountLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalAmountLeg2", (BigDecimal) o.getNotionalAmountLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrencyLeg1", (ISOCurrencyCodeEnum) o.getNotionalCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrencyLeg2", (ISOCurrencyCodeEnum) o.getNotionalCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("callAmount", (BigDecimal) o.getCallAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("callCurrency", (ISOCurrencyCodeEnum) o.getCallCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("putAmount", (BigDecimal) o.getPutAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("putCurrency", (ISOCurrencyCodeEnum) o.getPutCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalQuantityLeg1", (BigDecimal) o.getNotionalQuantityLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalQuantityLeg2", (BigDecimal) o.getNotionalQuantityLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyLeg1", (String) o.getQuantityFrequencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyLeg2", (String) o.getQuantityFrequencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyMultiplierLeg1", (Integer) o.getQuantityFrequencyMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyMultiplierLeg2", (Integer) o.getQuantityFrequencyMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityUnitOfMeasureLeg1", (String) o.getQuantityUnitOfMeasureLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityUnitOfMeasureLeg2", (String) o.getQuantityUnitOfMeasureLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityLeg1", (BigDecimal) o.getTotalNotionalQuantityLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityLeg2", (BigDecimal) o.getTotalNotionalQuantityLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageIndicator", (Boolean) o.getPackageIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("packageTransactionPrice", (BigDecimal) o.getPackageTransactionPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPriceCurrency", (ISOCurrencyCodeEnum) o.getPackageTransactionPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPriceNotation", (String) o.getPackageTransactionPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpread", (BigDecimal) o.getPackageTransactionSpread() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpreadCurrency", (ISOCurrencyCodeEnum) o.getPackageTransactionSpreadCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpreadNotation", (String) o.getPackageTransactionSpreadNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateDayCountConventionLeg1", (InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateDayCountConventionLeg2", (InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateDayCountConventionLeg1", (InterestComputationMethod4Code) o.getFloatingRateDayCountConventionLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateDayCountConventionLeg2", (InterestComputationMethod4Code) o.getFloatingRateDayCountConventionLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodLeg1", (String) o.getFloatingRateResetFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodLeg2", (String) o.getFloatingRateResetFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodMultiplierLeg1", (Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodMultiplierLeg2", (Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodLeg1", (String) o.getFixedRatePaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodLeg2", (String) o.getFixedRatePaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodLeg1", (String) o.getFloatingRatePaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodLeg2", (String) o.getFloatingRatePaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodMultiplierLeg1", (Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodMultiplierLeg2", (Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodMultiplierLeg1", (Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodMultiplierLeg2", (Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRateLeg1", (BigDecimal) o.getExchangeRateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRateBasis", (String) o.getExchangeRateBasis() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateLeg1", (BigDecimal) o.getFixedRateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateLeg2", (BigDecimal) o.getFixedRateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("postPricedSwapIndicator", (Boolean) o.getPostPricedSwapIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("price", (BigDecimal) o.getPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceCurrency", (ISOCurrencyCodeEnum) o.getPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceNotation", (String) o.getPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceUnitOfMeasure", (String) o.getPriceUnitOfMeasure() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg1", (BigDecimal) o.getSpreadLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg2", (BigDecimal) o.getSpreadLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadCurrencyLeg1", (ISOCurrencyCodeEnum) o.getSpreadCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadCurrencyLeg2", (ISOCurrencyCodeEnum) o.getSpreadCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadNotationLeg1", (String) o.getSpreadNotationLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadNotationLeg2", (String) o.getSpreadNotationLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePrice", (BigDecimal) o.getStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceCurrency", (String) o.getStrikePriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceNotation", (String) o.getStrikePriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumAmount", (BigDecimal) o.getOptionPremiumAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumCurrency", (ISOCurrencyCodeEnum) o.getOptionPremiumCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("firstExerciseDate", (Date) o.getFirstExerciseDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("indexFactor", (BigDecimal) o.getIndexFactor() != null ? 1 : 0, 0, 1), 
				checkCardinality("embeddedOptionType", (String) o.getEmbeddedOptionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueProductIdentifier", (String) o.getUniqueProductIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrencyLeg1", (ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrencyLeg2", (ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementLocationLeg1", (String) o.getSettlementLocationLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementLocationLeg2", (String) o.getSettlementLocationLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("nonStandardizedTermIndicator", (Boolean) o.getNonStandardizedTermIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("blockTradeElectionIndicator", (Boolean) o.getBlockTradeElectionIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("effectiveDate", (Date) o.getEffectiveDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("expirationDate", (Date) o.getExpirationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionTimestamp", (ZonedDateTime) o.getExecutionTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("platformIdentifier", (String) o.getPlatformIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("primeBrokerageTransactionIndicator", (Boolean) o.getPrimeBrokerageTransactionIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueSwapIdentifier", (String) o.getUniqueSwapIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueTransactionIdentifier", (String) o.getUniqueTransactionIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("cftcGuidebook", (CFTCGuidebookPart43) o.getCftcGuidebook() != null ? 1 : 0, 1, 1), 
				checkCardinality("nonReportable", (CFTCNonReportablePart43) o.getNonReportable() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CFTCPart43TransactionReport", ValidationResult.ValidationType.CARDINALITY, "CFTCPart43TransactionReport", path, "", res.getError());
				}
				return success("CFTCPart43TransactionReport", ValidationResult.ValidationType.CARDINALITY, "CFTCPart43TransactionReport", path, "");
			})
			.collect(toList());
	}

}
